/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.biz.crm.common.form.sdk.model.OperationStrategyService;
import com.biz.crm.common.form.sdk.module.ModuleRegister;
import com.biz.crm.common.form.sdk.vo.DynamicFieldVo;
import com.biz.crm.common.form.sdk.vo.DynamicFormVo;
import com.biz.crm.common.form.sdk.widget.WidgetKey;
import com.biz.crm.tpm.business.activities.sdk.dto.DynamicTemplateDto;
import com.biz.crm.tpm.business.activities.sdk.service.DynamicTemplateService;
import com.biz.crm.tpm.business.activities.sdk.vo.DynamicTemplateVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DynamicTemplateServiceImpl
implements DynamicTemplateService {
    private static final Map<String, String> CLASS_MAPPING = Maps.newConcurrentMap();
    @Order
    @Autowired(required=false)
    private List<ModuleRegister> moduleRegisters;
    @Order
    @Autowired(required=false)
    private List<OperationStrategy<? extends DynamicForm>> operationStrateis;
    @Autowired
    private OperationStrategyService operationStrategyService;

    public Page<DynamicTemplateVo> findByConditions(Pageable pageable, DynamicTemplateDto dto) {
        if (CollectionUtils.isEmpty(this.moduleRegisters) || CollectionUtils.isEmpty(this.operationStrateis)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new DynamicTemplateDto();
        }
        List<Object> templates = Lists.newArrayList();
        for (ModuleRegister moduleRegister : this.moduleRegisters) {
            String moduleCode = moduleRegister.moduleCode();
            String moduleName = moduleRegister.moduleName();
            for (OperationStrategy<? extends DynamicForm> operationStrategy : this.operationStrateis) {
                String moduleCodeItem = operationStrategy.moduleCode();
                if (!StringUtils.equals((CharSequence)moduleCode, (CharSequence)moduleCodeItem)) continue;
                String dynamicFormCode = operationStrategy.dynamicFormCode();
                String dynamicFormName = operationStrategy.dynamicFormName();
                Class dynamicClass = operationStrategy.dynamicFormClass();
                DynamicTemplateVo template = new DynamicTemplateVo();
                template.setModuleCode(moduleCode);
                template.setModuleName(moduleName);
                template.setDynamicFormCode(dynamicFormCode);
                template.setDynamicFormName(dynamicFormName);
                template.setDynamicFormSimpleClass(dynamicClass.getSimpleName());
                templates.add(template);
            }
        }
        if (CollectionUtils.isEmpty((Collection)templates)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getModuleCode())) {
            String moduleCode = dto.getModuleCode();
            templates = templates.stream().filter(e -> StringUtils.equals((CharSequence)moduleCode, (CharSequence)e.getModuleCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getModuleName())) {
            String moduleName = dto.getModuleName();
            templates = templates.stream().filter(e -> StringUtils.indexOf((CharSequence)e.getModuleName(), (CharSequence)moduleName) >= 0).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDynamicFormCode())) {
            String dynamicFormCode = dto.getDynamicFormCode();
            templates = templates.stream().filter(e -> StringUtils.equals((CharSequence)dynamicFormCode, (CharSequence)e.getDynamicFormCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDynamicFormName())) {
            String dynamicFormName = dto.getDynamicFormName();
            templates = templates.stream().filter(e -> StringUtils.indexOf((CharSequence)e.getDynamicFormName(), (CharSequence)dynamicFormName) >= 0).collect(Collectors.toList());
        }
        long totalSize = templates.size();
        templates = templates.stream().skip(pageable.getPageSize() * (pageable.getPageNumber() > 0 ? pageable.getPageNumber() - 1 : 0)).limit(pageable.getPageSize()).collect(Collectors.toList());
        Page result = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        result.setRecords((List)templates);
        result.setTotal(totalSize);
        return result;
    }

    public JSONObject findByDynamicFormCode(String dynamicFormCode) {
        if (StringUtils.isBlank((CharSequence)dynamicFormCode)) {
            return null;
        }
        DynamicFormVo dynamicForm = this.operationStrategyService.findByDynamicFormCode(dynamicFormCode);
        if (dynamicForm == null) {
            return null;
        }
        return this.buildJson(dynamicForm);
    }

    private JSONObject buildJson(DynamicFormVo dynamicForm) {
        JSONObject result = new JSONObject();
        result.put("dynamicFormCode", (Object)dynamicForm.getDynamicFormCode());
        result.put("dynamicFormFieldCode", (Object)"items");
        JSONArray dynamicFieldJsons = new JSONArray();
        List dynamicFields = dynamicForm.getDynamicFields();
        for (DynamicFieldVo dynamicFieldVo : dynamicFields) {
            Class fieldClass = dynamicFieldVo.getFieldClass();
            Boolean array = dynamicFieldVo.getArray();
            Boolean collection = dynamicFieldVo.getCollection();
            String fieldName = dynamicFieldVo.getFieldName();
            String fieldCode = dynamicFieldVo.getFieldCode();
            boolean required = dynamicFieldVo.isRequired();
            boolean modifiable = dynamicFieldVo.isModifiable();
            WidgetKey controllKey = dynamicFieldVo.getControllKey();
            JSONObject widgetKeyJson = new JSONObject();
            String widgetCode = controllKey.widgetCode();
            String widgetName = controllKey.widgetName();
            Map widgetParam = controllKey.widgetParam();
            widgetKeyJson.put("widgetCode", (Object)widgetCode);
            widgetKeyJson.put("widgetName", (Object)widgetName);
            widgetKeyJson.put("widgetParam", (Object)widgetParam);
            JSONObject dynamicFieldJson = new JSONObject();
            dynamicFieldJson.put("fieldClass", (Object)fieldClass);
            dynamicFieldJson.put("frontClass", (Object)this.transferToFrontClass(fieldClass, array, collection));
            dynamicFieldJson.put("array", (Object)array);
            dynamicFieldJson.put("fieldName", (Object)fieldName);
            dynamicFieldJson.put("fieldCode", (Object)fieldCode);
            dynamicFieldJson.put("required", (Object)required);
            dynamicFieldJson.put("modifiable", (Object)modifiable);
            dynamicFieldJson.put("collection", (Object)collection);
            dynamicFieldJson.put("controllKey", (Object)widgetKeyJson);
            dynamicFieldJsons.add((Object)dynamicFieldJson);
        }
        result.put("dynamicFields", (Object)dynamicFieldJsons);
        return result;
    }

    private String transferToFrontClass(Class<?> fieldClass, Boolean array, Boolean collection) {
        String fieldClassStr = fieldClass.getName();
        if (CLASS_MAPPING.containsKey(fieldClassStr)) {
            return CLASS_MAPPING.get(fieldClassStr);
        }
        if (fieldClass.isPrimitive()) {
            if (fieldClass == Boolean.TYPE) {
                CLASS_MAPPING.put(fieldClassStr, "boolean");
                return CLASS_MAPPING.get(fieldClassStr);
            }
            if (fieldClass == Character.TYPE) {
                CLASS_MAPPING.put(fieldClassStr, "string");
                return CLASS_MAPPING.get(fieldClassStr);
            }
            CLASS_MAPPING.put(fieldClassStr, "number");
            return CLASS_MAPPING.get(fieldClassStr);
        }
        if (fieldClass == Boolean.class) {
            CLASS_MAPPING.put(fieldClassStr, "boolean");
            return CLASS_MAPPING.get(fieldClassStr);
        }
        if (fieldClass == Character.class) {
            CLASS_MAPPING.put(fieldClassStr, "string");
            return CLASS_MAPPING.get(fieldClassStr);
        }
        if (array.booleanValue() || collection.booleanValue()) {
            CLASS_MAPPING.put(fieldClassStr, "array");
            return CLASS_MAPPING.get(fieldClassStr);
        }
        if (fieldClass == String.class) {
            CLASS_MAPPING.put(fieldClassStr, "string");
            return CLASS_MAPPING.get(fieldClassStr);
        }
        if (fieldClass == Date.class) {
            CLASS_MAPPING.put(fieldClassStr, "date");
            return CLASS_MAPPING.get(fieldClassStr);
        }
        if (Number.class.isAssignableFrom(fieldClass)) {
            CLASS_MAPPING.put(fieldClassStr, "number");
            return CLASS_MAPPING.get(fieldClassStr);
        }
        CLASS_MAPPING.put(fieldClassStr, "object");
        return CLASS_MAPPING.get(fieldClassStr);
    }
}

