/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.task;

import com.biz.crm.tpm.business.activities.sdk.service.BasicActivitiesInfoService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivitiesTask {
    @Autowired(required=false)
    private List<BasicActivitiesInfoService> basicActivitiesInfoServices;
    @Autowired
    private RedisMutexService redisMutexService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @DynamicTaskService(cornExpression="0 */10 * * * ?", taskDesc="\u6bcf10\u5206\u949f\u6267\u884c\uff1a\u68c0\u6d4b\u6d3b\u52a8\u662f\u5426\u5230\u671f")
    public void autoRefreshActivityStatusForActivityTime() {
        if (CollectionUtils.isEmpty(this.basicActivitiesInfoServices)) {
            return;
        }
        boolean hasLock = false;
        try {
            hasLock = this.redisMutexService.tryLock("GLOBAL_ACTIVITY_STATUS_REDIS_LOCK", TimeUnit.SECONDS, 10);
            if (hasLock) {
                for (BasicActivitiesInfoService basicActivitiesInfoService : this.basicActivitiesInfoServices) {
                    basicActivitiesInfoService.refreshActivityStatusForActivityTime();
                }
            }
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock("GLOBAL_ACTIVITY_STATUS_REDIS_LOCK");
            }
        }
    }
}

