/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.ordinary.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activities.ordinary.dto.OrdinaryActivityDto;
import com.biz.crm.tpm.business.activities.ordinary.entity.OrdinaryActivity;
import com.biz.crm.tpm.business.activities.ordinary.mapper.OrdinaryActivityMapper;
import com.biz.crm.tpm.business.activities.ordinary.vo.OrdinaryActivityVo;
import com.biz.crm.tpm.business.activities.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.activities.sdk.template.BaseActivity;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class OrdinaryActivityRepository
extends ServiceImpl<OrdinaryActivityMapper, OrdinaryActivity> {
    @Autowired
    private OrdinaryActivityMapper ordinaryActivityMapper;

    public Page<OrdinaryActivityVo> findByConditions(Pageable pageable, OrdinaryActivityDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.ordinaryActivityMapper.findByConditions((Page<OrdinaryActivityVo>)page, dto);
    }

    public OrdinaryActivity findByCodeAndTenantCode(String code, String tenantCode) {
        return (OrdinaryActivity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseActivity::getCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<OrdinaryActivity> findByCodesAndTenantCode(Set<String> codes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseActivity::getCode, codes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateStateByCode(String code, String state) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseActivity::getCode, (Object)code)).set(WorkflowFlagOpEntity::getProcessStatus, (Object)state)).update();
    }

    public int countByCostTypeCategoryCodeAndTenantCode(String costTypeCategoryCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseActivity::getCostTypeCategoryCode, (Object)costTypeCategoryCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).count();
    }

    public void updateForClose(String code, Boolean isAllClosed) {
        ActivityStatusEnum status = isAllClosed != false ? ActivityStatusEnum.ALL_CLOSE : ActivityStatusEnum.PARTIAL_CLOSE;
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseActivity::getCode, (Object)code)).set(BaseActivity::getStatus, (Object)status.getCode())).update();
    }

    public List<OrdinaryActivity> findByRefreshStatusTask() {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().notIn(BaseActivity::getStatus, (Collection)Sets.newHashSet((Object[])new String[]{ActivityStatusEnum.ALL_CLOSE.getCode(), ActivityStatusEnum.PARTIAL_CLOSE.getCode(), ActivityStatusEnum.ENDED.getCode()}))).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
    }
}

