/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.project.service.internal;

import com.biz.crm.tpm.business.activities.project.dto.ProjectActivityFilesDto;
import com.biz.crm.tpm.business.activities.project.entity.ProjectActivityFiles;
import com.biz.crm.tpm.business.activities.project.repository.ProjectActivityFilesRepository;
import com.biz.crm.tpm.business.activities.project.service.ProjectActivityFilesService;
import com.biz.crm.tpm.business.activities.project.vo.ProjectActivityFilesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProjectActivityFilesServiceImpl
implements ProjectActivityFilesService {
    @Autowired
    private ProjectActivityFilesRepository projectActivityFilesRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void save(List<ProjectActivityFilesDto> filesDtos, String activityCode) {
        Validate.notBlank((CharSequence)activityCode, (String)"\u9879\u76ee\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(filesDtos)) {
            for (ProjectActivityFilesDto filesDto : filesDtos) {
                Validate.notBlank((CharSequence)filesDto.getFileName(), (String)"\u9879\u76ee\u6d3b\u52a8\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)filesDto.getRefileName(), (String)"\u9879\u76ee\u6d3b\u52a8\u91cd\u547d\u540d\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)filesDto.getRelativePath(), (String)"\u9879\u76ee\u6d3b\u52a8\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)filesDto.getUrl(), (String)"\u9879\u76ee\u6d3b\u52a8\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            filesDtos.forEach(e -> {
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setId(null);
                e.setActivityCode(activityCode);
            });
        }
        this.projectActivityFilesRepository.deleteByActivityCodeAndTenantCode(activityCode, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(filesDtos)) {
            Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(filesDtos, ProjectActivityFilesDto.class, ProjectActivityFiles.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.projectActivityFilesRepository.saveBatch(entities);
        }
    }

    @Override
    public List<ProjectActivityFilesVo> findByActivityCode(String activityCode) {
        if (StringUtils.isBlank((CharSequence)activityCode)) {
            return Lists.newArrayList();
        }
        List<ProjectActivityFiles> entities = this.projectActivityFilesRepository.findByActivityCodeAndTenantCode(activityCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, ProjectActivityFiles.class, ProjectActivityFilesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }
}

