/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.project.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.context.DynamicFormContext;
import com.biz.crm.common.form.sdk.context.DynamicFormContextHolder;
import com.biz.crm.tpm.business.activities.dynamic.template.service.DynamicFormServiceResolver;
import com.biz.crm.tpm.business.activities.project.dto.ProjectActivityContextDto;
import com.biz.crm.tpm.business.activities.project.dto.ProjectActivityDto;
import com.biz.crm.tpm.business.activities.project.dto.ProjectActivityLogEventDto;
import com.biz.crm.tpm.business.activities.project.dto.ProjectActivityRelationDto;
import com.biz.crm.tpm.business.activities.project.entity.ProjectActivity;
import com.biz.crm.tpm.business.activities.project.entity.ProjectActivityRelation;
import com.biz.crm.tpm.business.activities.project.event.ProjectActivityLogEventListener;
import com.biz.crm.tpm.business.activities.project.repository.ProjectActivityRelationRepository;
import com.biz.crm.tpm.business.activities.project.repository.ProjectActivityRepository;
import com.biz.crm.tpm.business.activities.project.service.ProjectActivityFilesService;
import com.biz.crm.tpm.business.activities.project.service.ProjectActivityRelationService;
import com.biz.crm.tpm.business.activities.project.service.ProjectActivityService;
import com.biz.crm.tpm.business.activities.project.vo.ProjectActivityFilesVo;
import com.biz.crm.tpm.business.activities.project.vo.ProjectActivityRelationVo;
import com.biz.crm.tpm.business.activities.project.vo.ProjectActivityVo;
import com.biz.crm.tpm.business.activities.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.BasicActivitiesInfoService;
import com.biz.crm.tpm.business.activities.sdk.strategy.close.ActivityItemsClosedStrategy;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BaseActivityItemVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BasicActivityItemVo;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="_ProjectActivityServiceImpl")
public class ProjectActivityServiceImpl
implements ProjectActivityService,
BasicActivitiesInfoService {
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private ProjectActivityRepository projectActivityRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DynamicFormServiceResolver dynamicFormServiceResolver;
    @Autowired
    private ProjectActivityRelationRepository projectActivityRelationRepository;
    @Autowired
    private ProjectActivityRelationService projectActivityRelationService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private List<ActivitiesEventListener> activitiesEventListeners;
    @Autowired
    private ProjectActivityFilesService projectActivityFilesService;
    @Autowired(required=false)
    private List<ActivityItemsClosedStrategy> activitiesClosedStrategies;

    @Override
    public Page<ProjectActivityVo> findByConditions(Pageable pageable, ProjectActivityDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new ProjectActivityDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.projectActivityRepository.findByConditions(pageable, dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public ProjectActivityVo create(JSONObject json) {
        ProjectActivityDto dto = this.createValidation(json);
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setProcessStatus(ActApproveStatusEnum.CREATE.getCode());
        ProjectActivity entity = (ProjectActivity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ProjectActivity.class, HashSet.class, ArrayList.class, new String[]{"activityFiles", "relations", "attachmentVos"}));
        entity.setProcessStatus(ActApproveStatusEnum.CREATE.getCode());
        entity.setStatus(this.analysisStatus(dto.getStartTime(), dto.getEndTime()).getCode());
        this.projectActivityRepository.save((Object)entity);
        entity.getRelations().forEach(e -> e.setId(null));
        this.projectActivityRelationRepository.saveBatch(entity.getRelations());
        if (!CollectionUtils.isEmpty(dto.getActivityFiles())) {
            this.projectActivityFilesService.save(dto.getActivityFiles(), entity.getCode());
        }
        String parentCode = entity.getCode();
        Set dynamicFormServices = this.dynamicFormServiceResolver.getDynamicFormServices(json, "items", ProjectActivityVo.class);
        Validate.notEmpty((Collection)dynamicFormServices, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[0]);
        ProjectActivityVo projectActivityVo = (ProjectActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ProjectActivityVo.class, HashSet.class, ArrayList.class, new String[]{"relations", "attachmentVos"}));
        try {
            ProjectActivityContextDto contextDto = this.buildActivityContextDto(null, dto, true);
            DynamicFormContext context = this.prepareDynamicFormContext(contextDto);
            for (DynamicFormService dynamicFormService : dynamicFormServices) {
                dynamicFormService.createDynamicDetails((Object)projectActivityVo, parentCode);
            }
            this.validateTotalApplyAmount(context);
        }
        finally {
            DynamicFormContextHolder.clearContext();
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProcessKey())) {
            ProjectActivityVo activityVo = this.findByCode(entity.getCode());
            for (Map.Entry entry : activityVo.getItems().entrySet()) {
                List basicItems = JSONArray.parseArray((String)JSONArray.toJSONString(entry.getValue()), BasicActivityItemVo.class);
                Validate.notEmpty((Collection)basicItems, (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                for (BasicActivityItemVo basicItem : basicItems) {
                    this.costBudgetVoService.occupy(parentCode, basicItem.getItemCode(), basicItem.getCostBudgetCode(), basicItem.getApplyAmount(), basicItem.getRemark(), CostBudgetItemSourceType.PROJECT_ACTIVITY.getDescr());
                }
            }
            dto.setCode(entity.getCode());
            dto.setId(entity.getId());
            entity.setProcessNumber(this.commitProcess(dto));
            entity.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
            this.projectActivityRepository.saveOrUpdate((Object)entity);
        }
        ProjectActivityLogEventDto logEventDto = new ProjectActivityLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(projectActivityVo);
        SerializableBiConsumer & Serializable onCreate = ProjectActivityLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ProjectActivityLogEventListener.class, (SerializableBiConsumer)onCreate);
        return projectActivityVo;
    }

    @Override
    @Transactional
    public ProjectActivityVo update(JSONObject json) {
        List needAdds;
        ProjectActivityDto dto = this.updateValidation(json);
        ProjectActivityVo sourceProjectActivityVo = this.findByCode(dto.getCode());
        Validate.notNull((Object)((Object)sourceProjectActivityVo), (String)"\u6839\u636e\u6d3b\u52a8\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{dto.getCode()});
        ProjectActivityContextDto contextDto = this.buildActivityContextDto(sourceProjectActivityVo, dto, false);
        ProjectActivity dbProjectActivity = (ProjectActivity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)sourceProjectActivityVo, ProjectActivity.class, HashSet.class, ArrayList.class, new String[0]));
        dbProjectActivity.setEndTime(dto.getEndTime());
        dbProjectActivity.setName(dto.getName());
        dbProjectActivity.setRemark(dto.getRemark());
        dbProjectActivity.setStartTime(dto.getStartTime());
        dbProjectActivity.setItems(dto.getItems());
        dbProjectActivity.setTotalApplyAmount(dto.getTotalApplyAmount());
        dbProjectActivity.setStatus(this.analysisStatus(dto.getStartTime(), dto.getEndTime()).getCode());
        this.projectActivityRepository.saveOrUpdate((Object)dbProjectActivity);
        List<ProjectActivityRelation> dbProjectActivityRelations = this.projectActivityRelationRepository.findByActivityCodeAndTenantCode(dbProjectActivity.getCode(), dbProjectActivity.getTenantCode());
        dbProjectActivity.setRelations(dbProjectActivityRelations);
        Set currentIds = dto.getRelations().stream().map(UuidVo::getId).collect(Collectors.toSet());
        Set dbIds = dbProjectActivityRelations.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        Sets.SetView needDeletes = Sets.difference(dbIds, currentIds);
        if (!CollectionUtils.isEmpty((Collection)needDeletes)) {
            this.projectActivityRelationRepository.removeByIds((Collection)needDeletes);
            dbProjectActivity.getRelations().addAll(dbProjectActivityRelations.stream().filter(arg_0 -> ProjectActivityServiceImpl.lambda$update$1((Set)needDeletes, arg_0)).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(needAdds = dto.getRelations().stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toList()))) {
            ArrayList relations = Lists.newArrayList();
            for (Object e2 : needAdds) {
                e2.setId(null);
                ((ProjectActivityRelationDto)((Object)e2)).setActivityCode(dbProjectActivity.getCode());
                e2.setTenantCode(dbProjectActivity.getTenantCode());
                ProjectActivityRelation projectActivityRelation = (ProjectActivityRelation)((Object)this.nebulaToolkitService.copyObjectByWhiteList(e2, ProjectActivityRelation.class, HashSet.class, ArrayList.class, new String[0]));
                this.projectActivityRelationRepository.save((Object)projectActivityRelation);
                relations.add(projectActivityRelation);
            }
            dbProjectActivity.getRelations().addAll(relations);
        }
        if (!CollectionUtils.isEmpty(dto.getActivityFiles())) {
            this.projectActivityFilesService.save(dto.getActivityFiles(), dbProjectActivity.getCode());
        }
        ProjectActivityVo projectActivityVo = this.processDynamicFormsForUpdate(dbProjectActivity, contextDto);
        if (StringUtils.isNotBlank((CharSequence)dto.getProcessKey())) {
            ProjectActivityVo activityVo = this.findByCode(dbProjectActivity.getCode());
            for (Map.Entry entry : activityVo.getItems().entrySet()) {
                List basicActivityItemVos = JSONArray.parseArray((String)JSONArray.toJSONString(entry.getValue()), BasicActivityItemVo.class);
                Validate.notEmpty((Collection)basicActivityItemVos, (String)"\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                for (BasicActivityItemVo basicItem : basicActivityItemVos) {
                    this.costBudgetVoService.occupy(dbProjectActivity.getCode(), basicItem.getItemCode(), basicItem.getCostBudgetCode(), basicItem.getApplyAmount(), basicItem.getRemark(), CostBudgetItemSourceType.PROJECT_ACTIVITY.getDescr());
                }
            }
            dto.setCode(dbProjectActivity.getCode());
            dto.setId(dbProjectActivity.getId());
            dbProjectActivity.setProcessKey(dto.getProcessKey());
            dbProjectActivity.setProcessRemark(dto.getProcessRemark());
            dbProjectActivity.setProcessNumber(this.commitProcess(dto));
            dbProjectActivity.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
            this.projectActivityRepository.saveOrUpdate((Object)dbProjectActivity);
        }
        ProjectActivityLogEventDto logEventDto = new ProjectActivityLogEventDto();
        logEventDto.setOriginal(sourceProjectActivityVo);
        logEventDto.setNewest(projectActivityVo);
        SerializableBiConsumer & Serializable onUpdate = ProjectActivityLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ProjectActivityLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return projectActivityVo;
    }

    private String commitProcess(ProjectActivityDto dto) {
        StartProcessDto activitiBusinessVo = new StartProcessDto();
        activitiBusinessVo.setProcessKey(dto.getProcessKey());
        activitiBusinessVo.setBusinessId(dto.getId());
        activitiBusinessVo.setBusinessNo(dto.getCode());
        activitiBusinessVo.setRemark(dto.getProcessRemark());
        activitiBusinessVo.setAttachmentVos(dto.getAttachmentVos());
        activitiBusinessVo.setMenuCode(dto.getCompetenceCode());
        activitiBusinessVo.setFormType("PROJECT_ACTIVITIES_PROCESS");
        activitiBusinessVo.setProcessTitle(dto.getProcessTitle());
        HashMap<String, BigDecimal> maps = new HashMap<String, BigDecimal>();
        maps.put("totalApplyAmount", dto.getTotalApplyAmount());
        activitiBusinessVo.setVariables(maps);
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)activitiBusinessVo, ProcessListener.class, (SerializableBiConsumer)sf);
        if (StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId())) {
            return response.getProcessInstanceId();
        }
        throw new RuntimeException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01");
    }

    @Override
    public ProjectActivityVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ProjectActivity projectActivity = this.projectActivityRepository.findByCodeAndTenantCode(code, TenantUtils.getTenantCode());
        if (projectActivity == null || StringUtils.isBlank((CharSequence)projectActivity.getCode())) {
            return null;
        }
        List<ProjectActivityFilesVo> projectActivityFilesVos = this.projectActivityFilesService.findByActivityCode(code);
        ProjectActivityVo projectActivityVo = (ProjectActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)projectActivity, ProjectActivityVo.class, HashSet.class, ArrayList.class, new String[0]));
        List<ProjectActivityRelationVo> projectActivityRelations = this.projectActivityRelationService.findByActivityCode(projectActivity.getCode());
        if (CollectionUtils.isEmpty(projectActivityRelations)) {
            return null;
        }
        projectActivityVo.setRelations(projectActivityRelations);
        projectActivityVo.setActivityFiles(projectActivityFilesVos);
        Set dynamicKeys = projectActivityRelations.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode())).map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{e.getCostBudgetCode(), e.getCostTypeCategoryCode()})).collect(Collectors.toSet());
        for (String dynamicKey : dynamicKeys) {
            DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ProjectActivityVo.class);
            if (dynamicFormService == null) continue;
            dynamicFormService.perfectDynamicDetails((Object)projectActivityVo, projectActivityVo.getCode());
        }
        return projectActivityVo;
    }

    @Override
    public ProjectActivityVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProjectActivity projectActivity = (ProjectActivity)((Object)this.projectActivityRepository.getById((Serializable)((Object)id)));
        if (projectActivity == null) {
            return null;
        }
        List<ProjectActivityFilesVo> projectActivityFilesVos = this.projectActivityFilesService.findByActivityCode(projectActivity.getCode());
        ProjectActivityVo projectActivityVo = (ProjectActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)projectActivity, ProjectActivityVo.class, HashSet.class, ArrayList.class, new String[0]));
        List<ProjectActivityRelationVo> projectActivityRelations = this.projectActivityRelationService.findByActivityCode(projectActivity.getCode());
        if (CollectionUtils.isEmpty(projectActivityRelations)) {
            return null;
        }
        projectActivityVo.setRelations(projectActivityRelations);
        projectActivityVo.setActivityFiles(projectActivityFilesVos);
        Set dynamicKeys = projectActivityRelations.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode())).map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{e.getCostBudgetCode(), e.getCostTypeCategoryCode()})).collect(Collectors.toSet());
        for (String dynamicKey : dynamicKeys) {
            DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ProjectActivityVo.class);
            if (dynamicFormService == null) continue;
            dynamicFormService.perfectDynamicDetails((Object)projectActivityVo, projectActivityVo.getCode());
        }
        return projectActivityVo;
    }

    @Override
    public List<ProjectActivityVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List projectActivities = this.projectActivityRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)projectActivities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)projectActivities, ProjectActivity.class, ProjectActivityVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    public void updateStateByCode(String code, String state) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)code), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)state), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.projectActivityRepository.updateStateByCode(code, state);
        if (!CollectionUtils.isEmpty(this.activitiesEventListeners)) {
            ProjectActivityVo byCode = this.findByCode(code);
            ActivitiesVo vo = (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byCode, ActivitiesVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setActivitiesCode(byCode.getCode());
            this.activitiesEventListeners.forEach(event -> event.onUpdateProcessStatus(vo));
        }
    }

    @Override
    @Transactional
    public void delete(Set<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ProjectActivityVo> projectActivityVos = this.findByIds(ids);
        Validate.notEmpty(projectActivityVos, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        projectActivityVos.forEach(e -> Validate.isTrue((boolean)StringUtils.equals((CharSequence)e.getProcessStatus(), (CharSequence)ActApproveStatusEnum.CREATE.getCode()), (String)"\u3010%s\u3011\u3010%s\u3011\u4e0d\u662f\u5f85\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c", (Object[])new Object[]{e.getName(), e.getCode()}));
        for (ProjectActivityVo projectActivityVo : projectActivityVos) {
            List<ProjectActivityRelationVo> projectActivityRelations = this.projectActivityRelationService.findByActivityCode(projectActivityVo.getCode());
            Validate.notEmpty(projectActivityRelations, (String)"\u3010%s\u3011\u3010%s\u3011\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[]{projectActivityVo.getName(), projectActivityVo.getCode()});
            projectActivityVo.setRelations(projectActivityRelations);
            this.projectActivityRelationService.deleteByActivityCode(projectActivityVo.getCode());
            this.projectActivityFilesService.save(null, projectActivityVo.getCode());
            Set dynamicKeys = projectActivityRelations.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode())).map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{e.getCostBudgetCode(), e.getCostTypeCategoryCode()})).collect(Collectors.toSet());
            for (String dynamicKey : dynamicKeys) {
                DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ProjectActivityVo.class);
                Validate.notNull((Object)dynamicFormService, (String)"\u3010%s\u3011\u3010%s\u3011\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[]{projectActivityVo.getName(), projectActivityVo.getCode()});
                dynamicFormService.deleteDynamicDetails(projectActivityVo.getCode());
            }
        }
        this.projectActivityRepository.deleteByIds(Lists.newArrayList(ids));
        SerializableBiConsumer & Serializable onDelete = ProjectActivityLogEventListener::onDelete;
        for (ProjectActivityVo projectActivityVo : projectActivityVos) {
            ProjectActivityLogEventDto logEventDto = new ProjectActivityLogEventDto();
            logEventDto.setOriginal(projectActivityVo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ProjectActivityLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    private ProjectActivityDto createValidation(JSONObject json) {
        Validate.notNull((Object)json, (String)"\u9879\u76ee\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProjectActivityDto dto = (ProjectActivityDto)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json), ProjectActivityDto.class));
        this.createValidation(dto);
        return dto;
    }

    private void createValidation(ProjectActivityDto dto) {
        Validate.notNull((Object)((Object)dto), (String)"\u9879\u76ee\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        this.validateBase(dto);
        String ruleCode = StringUtils.join((Object[])new String[]{"XMHD", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Validate.notEmpty((Collection)codeList, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u9879\u76ee\u6d3b\u52a8\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        dto.setCode((String)codeList.get(0));
        String pattern = "^[A-Z]{1}[A-Z0-9]*$";
        Validate.matchesPattern((CharSequence)dto.getCode(), (String)pattern, (String)"\u7f16\u7801\u53ea\u80fd\u662f\u5b57\u6bcd\u548c\u6570\u5b57\u6784\u6210\uff0c\u4e14\u9996\u5b57\u6bcd\u4e0d\u80fd\u662f\u6570\u5b57\uff0c\u6700\u7ec8\u7f16\u7801\u90fd\u5c06\u88ab\u5927\u5199", (Object[])new Object[0]);
        ProjectActivityVo projectActivityVo = this.findByCode(dto.getCode());
        Validate.isTrue((projectActivityVo == null ? 1 : 0) != 0, (String)"\u9879\u76ee\u6d3b\u52a8\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
        for (ProjectActivityRelationDto relation : dto.getRelations()) {
            relation.setActivityCode(dto.getCode());
            relation.setTenantCode(dto.getTenantCode());
            Validate.notBlank((CharSequence)relation.getCostBudgetCode(), (String)"\u5173\u8054\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!StringUtils.isNotBlank((CharSequence)relation.getCostTypeCategoryCode()) && !StringUtils.isNotBlank((CharSequence)relation.getCostTypeCategoryName())) continue;
            Validate.notBlank((CharSequence)relation.getCostTypeCategoryCode(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)relation.getCostTypeCategoryName(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void validateBase(ProjectActivityDto dto) {
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u9879\u76ee\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((NumberUtils.compare((long)dto.getEndTime().getTime(), (long)dto.getStartTime().getTime()) > 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getTotalApplyAmount(), (String)"\u603b\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getTotalApplyAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u603b\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notEmpty(dto.getRelations(), (String)"\u9879\u76ee\u6d3b\u52a8\u5173\u8054\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getRelations().stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode())), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(dto.getItems(), (String)"\u9879\u76ee\u6d3b\u52a8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private ProjectActivityDto updateValidation(JSONObject json) {
        Validate.notNull((Object)json, (String)"\u9879\u76ee\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProjectActivityDto dto = (ProjectActivityDto)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)json), ProjectActivityDto.class));
        this.updateValidation(dto);
        return dto;
    }

    private void updateValidation(ProjectActivityDto dto) {
        Validate.notNull((Object)((Object)dto), (String)"\u9879\u76ee\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u66f4\u65b0\u65f6\uff0c\u4e3b\u952eid\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        ProjectActivityVo projectActivityVo = this.findById(dto.getId());
        Validate.notNull((Object)((Object)projectActivityVo), (String)"\u6839\u636e\u63d0\u4f9b\u7684id\u4e3b\u952e\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)dto.getCode(), (CharSequence)projectActivityVo.getCode()), (String)"\u4f20\u5165\u7684\u9879\u76ee\u6d3b\u52a8\u7f16\u7801\u4e0e\u6570\u636e\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.validateBase(dto);
        for (ProjectActivityRelationDto relation : dto.getRelations()) {
            if (StringUtils.isBlank((CharSequence)relation.getActivityCode())) {
                relation.setActivityCode(dto.getCode());
            }
            if (StringUtils.isBlank((CharSequence)relation.getTenantCode())) {
                relation.setTenantCode(dto.getTenantCode());
            }
            Validate.isTrue((boolean)relation.getActivityCode().equals(dto.getCode()), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0e\u8d39\u7528\u9884\u7b97\u6240\u5173\u8054\u7684\u9879\u76ee\u6d3b\u52a8\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)relation.getCostBudgetCode(), (String)"\u5173\u8054\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)relation.getCostTypeCategoryCode()) || StringUtils.isNotBlank((CharSequence)relation.getCostTypeCategoryName())) {
                Validate.notBlank((CharSequence)relation.getCostTypeCategoryCode(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)relation.getCostTypeCategoryName(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Validate.notBlank((CharSequence)relation.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private ProjectActivityContextDto buildActivityContextDto(ProjectActivityVo sourceActivity, ProjectActivityDto targetActivity, boolean addOperate) {
        ProjectActivityContextDto contextDto = new ProjectActivityContextDto();
        Validate.notNull((Object)((Object)targetActivity), (String)"\u6700\u65b0\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        contextDto.setTargetActivity(targetActivity);
        if (!addOperate) {
            Validate.notNull((Object)((Object)sourceActivity), (String)"\u5386\u53f2\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            contextDto.setSourceActivity(sourceActivity);
        }
        return contextDto;
    }

    private DynamicFormContext prepareDynamicFormContext(ProjectActivityContextDto contextDto) {
        ProjectActivityDto targetActivity = contextDto.getTargetActivity();
        ProjectActivityVo sourceActivity = contextDto.getSourceActivity();
        Validate.notNull((Object)targetActivity.getTotalApplyAmount(), (String)"\u603b\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((targetActivity.getTotalApplyAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u603b\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notEmpty(targetActivity.getRelations(), (String)"\u9879\u76ee\u6d3b\u52a8\u5173\u8054\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicFormContext context = DynamicFormContextHolder.getContext();
        context.put("targetTotalApplyAmount", (Object)targetActivity.getTotalApplyAmount());
        context.put("sumTotalApplyAmount", (Object)BigDecimal.ZERO);
        context.put("startTime", (Object)targetActivity.getStartTime());
        context.put("endTime", (Object)targetActivity.getEndTime());
        if (sourceActivity != null) {
            context.put("sourceTotalApplyAmount", (Object)sourceActivity.getTotalApplyAmount());
        }
        return context;
    }

    @Transactional
    public void onClosed(Map<String, Set<String>> codeMap) {
        Validate.notEmpty(codeMap, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u4f20\u5165\u7684\u6d3b\u52a8\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ActivitiesVo> activitiesVos = this.findDetailsByParentCodes(codeMap.keySet());
        if (CollectionUtils.isEmpty(activitiesVos)) {
            return;
        }
        Collection projectActivityVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesVos, ActivitiesVo.class, ProjectActivityVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProjectActivityVo projectActivityVo : projectActivityVos) {
            Map<String, List<BaseActivityItemVo>> itemMap = projectActivityVo.getItems();
            Set<String> waiteToCloseCodes = codeMap.get(projectActivityVo.getCode());
            HashMap closedStatus = Maps.newHashMap();
            for (Map.Entry<String, List<BaseActivityItemVo>> entry : itemMap.entrySet()) {
                String dynamicFormCode = entry.getValue().get(0).getDynamicFormCode();
                Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u9879\u76ee\u6d3b\u52a8\u3010%s\u3011\u6d3b\u52a8\u660e\u7ec6\u5bf9\u5e94\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{projectActivityVo.getCode()});
                Set itemCodes = entry.getValue().stream().map(BaseActivityItemVo::getItemCode).collect(Collectors.toSet());
                ActivityItemsClosedStrategy strategy = null;
                for (ActivityItemsClosedStrategy activityItemsClosedStrategy : this.activitiesClosedStrategies) {
                    if (!activityItemsClosedStrategy.dynamicFormCode().equals(dynamicFormCode)) continue;
                    strategy = activityItemsClosedStrategy;
                    break;
                }
                Validate.notNull(strategy, (String)"\u6d3b\u52a8\u5173\u95ed\u65f6\uff0c\u6839\u636e\u63d0\u4f9b\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u3010%s\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7b56\u7565\u4fe1\u606f", (Object[])new Object[]{dynamicFormCode});
                Sets.SetView intersections = Sets.intersection(waiteToCloseCodes, itemCodes);
                if (CollectionUtils.isEmpty((Collection)intersections)) {
                    closedStatus.put(entry.getKey(), strategy.allClosed(projectActivityVo.getCode()));
                    continue;
                }
                strategy.closed((Set)intersections);
                boolean allClosed = strategy.allClosed(projectActivityVo.getCode());
                closedStatus.put(entry.getKey(), allClosed);
            }
            boolean isAllClosed = closedStatus.values().stream().allMatch(e -> e != null && e != false);
            this.projectActivityRepository.updateForClose(projectActivityVo.getCode(), isAllClosed);
        }
    }

    @Transactional
    public void refreshActivityStatusForActivityTime() {
        List<ProjectActivity> activities = this.projectActivityRepository.findByRefreshStatusTask();
        if (CollectionUtils.isEmpty(activities)) {
            return;
        }
        for (ProjectActivity projectActivity : activities) {
            ActivityStatusEnum activityStatusEnum = this.analysisStatus(projectActivity.getStartTime(), projectActivity.getEndTime());
            projectActivity.setStatus(activityStatusEnum.getCode());
        }
        this.projectActivityRepository.saveOrUpdateBatch(activities);
    }

    public String activityMark() {
        return "ProjectActivity";
    }

    public Map<String, List<BasicActivityItemVo>> findByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return Maps.newHashMap();
        }
        ProjectActivityVo projectActivityVo = this.findByCode(parentCode);
        if (projectActivityVo == null || CollectionUtils.isEmpty(projectActivityVo.getItems())) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, List<BaseActivityItemVo>> entry : projectActivityVo.getItems().entrySet()) {
            List<BaseActivityItemVo> itemVos = entry.getValue();
            List items = JSONArray.parseArray((String)JSONArray.toJSONString(itemVos), BasicActivityItemVo.class);
            result.put(entry.getKey(), items);
        }
        return result;
    }

    public ActivitiesVo findDetailsByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        ProjectActivityVo projectActivityVo = this.findByCode(parentCode);
        if (projectActivityVo == null) {
            return null;
        }
        return (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)projectActivityVo, ActivitiesVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivitiesVo> findDetailsByParentCodes(Set<String> parentCodes) {
        if (CollectionUtils.isEmpty(parentCodes)) {
            return Lists.newArrayList();
        }
        List<ProjectActivity> projectActivities = this.projectActivityRepository.findByCodesAndTenantCode(parentCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(projectActivities)) {
            return Lists.newArrayList();
        }
        List<ProjectActivityRelation> relationEntities = this.projectActivityRelationRepository.findByActivityCodesAndTenantCode(projectActivities.stream().map(ProjectActivity::getCode).collect(Collectors.toSet()), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(relationEntities)) {
            return Lists.newArrayList();
        }
        Collection projectActivityVos = this.nebulaToolkitService.copyCollectionByWhiteList(projectActivities, ProjectActivity.class, ProjectActivityVo.class, HashSet.class, ArrayList.class, new String[0]);
        Collection relationVos = this.nebulaToolkitService.copyCollectionByWhiteList(relationEntities, ProjectActivityRelation.class, ProjectActivityRelationVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ProjectActivityVo projectActivityVo : projectActivityVos) {
            List<ProjectActivityRelationVo> relations = relationVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getActivityCode(), (CharSequence)projectActivityVo.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(relations)) continue;
            projectActivityVo.setRelations(relations);
            Set dynamicKeys = relations.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode())).map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{e.getCostBudgetCode(), e.getCostTypeCategoryCode()})).collect(Collectors.toSet());
            for (String dynamicKey : dynamicKeys) {
                DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ProjectActivityVo.class);
                if (dynamicFormService == null) continue;
                dynamicFormService.perfectDynamicDetails((Object)projectActivityVo, projectActivityVo.getCode());
            }
        }
        Collection activitiesVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)projectActivityVos, ProjectActivityVo.class, ActivitiesVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesVos);
    }

    public BasicActivityItemVo findByParentCodeAndItemCode(String parentCode, String itemCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        ProjectActivityVo projectActivityVo = this.findByCode(parentCode);
        if (projectActivityVo == null || CollectionUtils.isEmpty(projectActivityVo.getItems())) {
            return null;
        }
        for (Map.Entry<String, List<BaseActivityItemVo>> entry : projectActivityVo.getItems().entrySet()) {
            List<BaseActivityItemVo> itemVos = entry.getValue();
            List items = JSONArray.parseArray((String)JSONArray.toJSONString(itemVos), BasicActivityItemVo.class);
            for (BasicActivityItemVo item : items) {
                if (!StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)itemCode)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public boolean existByCostTypeCategoryCode(String costTypeCategoryCode) {
        if (StringUtils.isBlank((CharSequence)costTypeCategoryCode)) {
            return false;
        }
        List<ProjectActivityRelation> relations = this.projectActivityRelationRepository.findByCostTypeCategoryCodeAndTenantCode(costTypeCategoryCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(relations)) {
            return false;
        }
        Set<String> activityCodes = relations.stream().map(ProjectActivityRelation::getActivityCode).collect(Collectors.toSet());
        int result = this.projectActivityRepository.countByCodesAndTenantCode(activityCodes, TenantUtils.getTenantCode());
        return result > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectActivityVo processDynamicFormsForUpdate(ProjectActivity entity, ProjectActivityContextDto contextDto) {
        String parentCode = entity.getCode();
        Map<String, List<BasicActivityItemVo>> dbBasicItems = this.findByParentCode(parentCode);
        Validate.notEmpty(dbBasicItems, (String)"\u6839\u636e\u9879\u76ee\u6d3b\u52a8\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[]{parentCode});
        HashSet dbDynamicKeys = Sets.newHashSet(dbBasicItems.keySet());
        HashSet dynamicKeys = Sets.newHashSet(contextDto.getTargetActivity().getItems().keySet());
        ProjectActivityVo projectActivityVo = (ProjectActivityVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)contextDto.getTargetActivity(), ProjectActivityVo.class, HashSet.class, ArrayList.class, new String[]{"relations", "attachmentVos", "shareInfos"}));
        try {
            Sets.SetView needUpdateDynamicKeys;
            Sets.SetView needAddDynamicKeys;
            DynamicFormContext context = this.prepareDynamicFormContext(contextDto);
            Sets.SetView needDeleteDynamicForms = Sets.difference((Set)dbDynamicKeys, (Set)dynamicKeys);
            if (!CollectionUtils.isEmpty((Collection)needDeleteDynamicForms)) {
                for (Object dynamicKey : needDeleteDynamicForms) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService((String)dynamicKey, "items", ProjectActivityVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.deleteDynamicDetails(parentCode);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(needAddDynamicKeys = Sets.difference((Set)dynamicKeys, (Set)dbDynamicKeys)))) {
                for (String dynamicKey : needAddDynamicKeys) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ProjectActivityVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.createDynamicDetails((Object)projectActivityVo, parentCode);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(needUpdateDynamicKeys = Sets.intersection((Set)dynamicKeys, (Set)dbDynamicKeys)))) {
                for (String dynamicKey : needUpdateDynamicKeys) {
                    DynamicFormService dynamicFormService = this.dynamicFormServiceResolver.getDynamicFormService(dynamicKey, "items", ProjectActivityVo.class);
                    Validate.notNull((Object)dynamicFormService, (String)"\u6839\u636e\u63d0\u4f9b\u7684dynamicKey\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5339\u914d\u7684\u52a8\u6001\u6a21\u677f\u670d\u52a1\u7c7b\u4fe1\u606f", (Object[])new Object[]{dynamicKey});
                    dynamicFormService.modifyDynamicDetails((Object)projectActivityVo, parentCode);
                }
            }
            this.validateTotalApplyAmount(context);
        }
        finally {
            DynamicFormContextHolder.clearContext();
        }
        return projectActivityVo;
    }

    private void validateTotalApplyAmount(DynamicFormContext context) {
        if (context.exist("sumTotalApplyAmount") && context.exist("targetTotalApplyAmount")) {
            BigDecimal sumTotalApplyAmount;
            BigDecimal targetTotalApplyAmount = (BigDecimal)context.get("targetTotalApplyAmount");
            Validate.isTrue((targetTotalApplyAmount.compareTo(sumTotalApplyAmount = (BigDecimal)context.get("sumTotalApplyAmount")) == 0 ? 1 : 0) != 0, (String)"\u7d2f\u8ba1\u603b\u91d1\u989d\u4e0e\u7533\u8bf7\u7684\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.isTrue((targetTotalApplyAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u603b\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        }
    }

    private ActivityStatusEnum analysisStatus(Date startTime, Date endTime) {
        Date now = new Date();
        if (NumberUtils.compare((long)now.getTime(), (long)startTime.getTime()) < 0) {
            return ActivityStatusEnum.UNEXECUTED;
        }
        if (NumberUtils.compare((long)now.getTime(), (long)endTime.getTime()) > 0) {
            return ActivityStatusEnum.ENDED;
        }
        return ActivityStatusEnum.EXECUTING;
    }

    private static /* synthetic */ boolean lambda$update$1(Set needDeletes, ProjectActivityRelation e) {
        return !needDeletes.contains(e.getId());
    }
}

