/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.notifier;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.activities.scheme.dto.SchemeLogEventDto;
import com.biz.crm.tpm.business.activities.scheme.event.SchemeLogEventListener;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SchemeLogEventListenerImpl
implements SchemeLogEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    @Override
    public void onCreate(SchemeLogEventDto eventDto) {
        SchemeVo newest = eventDto.getNewest();
        SchemeVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onDelete(SchemeLogEventDto eventDto) {
        SchemeVo newest = eventDto.getNewest();
        SchemeVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onUpdate(SchemeLogEventDto eventDto) {
        SchemeVo newest = eventDto.getNewest();
        SchemeVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

