/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activities.scheme.dto.ActivitiesSchemeDto;
import com.biz.crm.tpm.business.activities.scheme.entity.ActivitiesScheme;
import com.biz.crm.tpm.business.activities.scheme.mapper.ActivitiesSchemeMapper;
import com.biz.crm.tpm.business.activities.scheme.vo.ActivitiesSchemeVo;
import com.biz.crm.tpm.business.activities.sdk.enums.ActivityStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivitiesSchemeRepository
extends ServiceImpl<ActivitiesSchemeMapper, ActivitiesScheme> {
    @Autowired
    private ActivitiesSchemeMapper activitiesSchemeMapper;

    public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public Page<ActivitiesSchemeVo> findByConditions(Pageable pageable, ActivitiesSchemeDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activitiesSchemeMapper.findByConditions((Page<ActivitiesSchemeVo>)page, dto);
    }

    public List<ActivitiesScheme> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public ActivitiesScheme findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ActivitiesScheme)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivitiesScheme::getActivitiesCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<ActivitiesScheme> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivitiesScheme::getActivitiesCode, codes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<ActivitiesScheme> findByEnableStatus(String enableStatus) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)enableStatus)) {
            return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        String tenantCode = TenantUtils.getTenantCode();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq((Object)"tenant_code", (Object)tenantCode);
        updateWrapper.in((Object)"id", idList);
        return this.update((Wrapper)updateWrapper);
    }

    public void updateStatusByCode(String code, String status) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ActivitiesScheme::getActivitiesCode, (Object)code)).set(WorkflowFlagOpEntity::getProcessStatus, (Object)status)).update();
    }

    public int countByScheme(String schemeCode) {
        if (StringUtils.isBlank((CharSequence)schemeCode)) {
            return 0;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ActivitiesScheme::getSchemeCode, (Object)schemeCode)).count();
    }

    public void updateForClose(String code, Boolean isAllClosed) {
        ActivityStatusEnum status = isAllClosed != false ? ActivityStatusEnum.ALL_CLOSE : ActivityStatusEnum.PARTIAL_CLOSE;
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ActivitiesScheme::getActivitiesCode, (Object)code)).set(ActivitiesScheme::getStatus, (Object)status.getCode())).update();
    }

    public List<ActivitiesScheme> findByRefreshStatusTask() {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().notIn(ActivitiesScheme::getStatus, (Collection)Sets.newHashSet((Object[])new String[]{ActivityStatusEnum.ALL_CLOSE.getCode(), ActivityStatusEnum.PARTIAL_CLOSE.getCode(), ActivityStatusEnum.ENDED.getCode()}))).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
    }
}

