/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activities.scheme.entity.SchemeRange;
import com.biz.crm.tpm.business.activities.scheme.mapper.SchemeRangeMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SchemeRangeRepository
extends ServiceImpl<SchemeRangeMapper, SchemeRange> {
    @Autowired
    private SchemeRangeMapper schemeRangeMapper;

    public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateEnableStatusByCodes(EnableStatusEnum enable, Set<String> codes) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"range_code", codes);
        this.update((Wrapper)updateWrapper);
    }

    public List<SchemeRange> findByIds(Collection<String> ids) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(SchemeRange::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SchemeRange> findByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SchemeRange::getRangeCode, codes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<SchemeRange> findBySchemeCode(String schemeCode) {
        if (StringUtils.isBlank((CharSequence)schemeCode)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SchemeRange::getSchemeCode, new Object[]{schemeCode})).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public void deleteBySchemeCode(String schemeCode) {
        if (StringUtils.isBlank((CharSequence)schemeCode)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(SchemeRange::getSchemeCode, (Object)schemeCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public List<SchemeRange> findAll() {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public void deleteByRangeCodes(Collection<String> codes) {
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(SchemeRange::getRangeCode, codes)).set(SchemeRange::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }
}

