/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activities.scheme.dto.SchemeDto;
import com.biz.crm.tpm.business.activities.scheme.entity.Scheme;
import com.biz.crm.tpm.business.activities.scheme.mapper.SchemeMapper;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SchemeRepository
extends ServiceImpl<SchemeMapper, Scheme> {
    @Autowired
    private SchemeMapper schemeMapper;

    public Page<SchemeVo> findByConditions(Pageable pageable, SchemeDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.schemeMapper.findByConditions((Page<SchemeVo>)page, dto);
    }

    public List<Scheme> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(Scheme::getTenantCode, (Object)tenantCode)).eq(Scheme::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Scheme findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (Scheme)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Scheme::getSchemeCode, (Object)code)).eq(Scheme::getTenantCode, (Object)tenantCode)).eq(Scheme::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<Scheme> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Scheme::getSchemeCode, codes)).eq(Scheme::getTenantCode, (Object)tenantCode)).eq(Scheme::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        String tenantCode = TenantUtils.getTenantCode();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq((Object)"tenant_code", (Object)tenantCode);
        updateWrapper.in((Object)"id", idList);
        return this.update((Wrapper)updateWrapper);
    }

    public Integer countByCostBudgetCode(String costBudgetCode) {
        String tenantCode = TenantUtils.getTenantCode();
        SchemeDto dto = new SchemeDto();
        dto.setTenantCode(tenantCode);
        dto.setCostBudgetCode(costBudgetCode);
        return this.schemeMapper.countByCostBudget(dto);
    }
}

