/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.service.internal;

import com.biz.crm.tpm.business.activities.scheme.entity.ActivitiesSchemeRelation;
import com.biz.crm.tpm.business.activities.scheme.repository.ActivitiesSchemeRelationRepository;
import com.biz.crm.tpm.business.activities.scheme.service.ActivitiesSchemeRelationService;
import com.biz.crm.tpm.business.activities.scheme.vo.ActivitiesSchemeRelationVo;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiesSchemeRelationServiceImpl
implements ActivitiesSchemeRelationService {
    @Autowired
    private ActivitiesSchemeRelationRepository activitiesSchemeRelationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CostBudgetVoService costBudgetVoService;

    @Override
    @Transactional
    public ActivitiesSchemeRelation save(ActivitiesSchemeRelationVo activitiesSchemeRelationVo) {
        this.createValidate(activitiesSchemeRelationVo);
        ActivitiesSchemeRelation activitiesSchemeRelation = (ActivitiesSchemeRelation)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesSchemeRelationVo, ActivitiesSchemeRelation.class, HashSet.class, ArrayList.class, new String[0]));
        this.activitiesSchemeRelationRepository.save((Object)activitiesSchemeRelation);
        return activitiesSchemeRelation;
    }

    @Override
    @Transactional
    public void saveBatch(List<ActivitiesSchemeRelationVo> activitiesSchemeRelationVos) {
        Validate.notEmpty(activitiesSchemeRelationVos, (String)"\u65b9\u6848\u6d3b\u52a8\u5173\u8054\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        activitiesSchemeRelationVos.forEach(this::createValidate);
        Collection activitiesSchemeRelations = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesSchemeRelationVos, ActivitiesSchemeRelationVo.class, ActivitiesSchemeRelation.class, HashSet.class, ArrayList.class, new String[0]);
        this.activitiesSchemeRelationRepository.saveBatch(activitiesSchemeRelations);
    }

    @Override
    public List<ActivitiesSchemeRelationVo> findByActivityCode(String activityCode) {
        String tenantCode = TenantUtils.getTenantCode();
        List<ActivitiesSchemeRelation> activitiesSchemeRelations = this.activitiesSchemeRelationRepository.findByActivityCodeAndTenantCode(activityCode, tenantCode);
        Collection activitiesSchemeRelationVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesSchemeRelations, ActivitiesSchemeRelation.class, ActivitiesSchemeRelationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Set costBudgetCodes = activitiesSchemeRelationVos.stream().map(ActivitiesSchemeRelationVo::getCostBudgetCode).collect(Collectors.toSet());
        List costBudgetVos = this.costBudgetVoService.findByCodes(costBudgetCodes);
        for (ActivitiesSchemeRelationVo relationVo : activitiesSchemeRelationVos) {
            CostBudgetVo costBudgetVo = costBudgetVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)relationVo.getCostBudgetCode())).findFirst().orElse(null);
            if (costBudgetVo == null) continue;
            relationVo.setBudgetSubjectCode(costBudgetVo.getBudgetSubjectCode());
            relationVo.setBudgetSubjectName(costBudgetVo.getBudgetSubjectName());
            relationVo.setChannelCode(costBudgetVo.getChannelCode());
            relationVo.setChannelName(costBudgetVo.getChannelName());
            relationVo.setCustomerCode(costBudgetVo.getCustomerCode());
            relationVo.setCustomerName(costBudgetVo.getCustomerName());
            relationVo.setFinalBalance(costBudgetVo.getFinalBalance());
            relationVo.setMonth(costBudgetVo.getMonth());
            relationVo.setOrgCode(costBudgetVo.getOrgCode());
            relationVo.setOrgName(costBudgetVo.getOrgName());
            relationVo.setProductCode(costBudgetVo.getProductCode());
            relationVo.setProductLevelCode(costBudgetVo.getProductLevelCode());
            relationVo.setProductLevelName(costBudgetVo.getProductLevelName());
            relationVo.setProductName(costBudgetVo.getProductName());
            relationVo.setQuarter(costBudgetVo.getQuarter());
            relationVo.setTerminalCode(costBudgetVo.getTerminalCode());
            relationVo.setTerminalName(costBudgetVo.getTerminalName());
            relationVo.setYear(costBudgetVo.getYear());
            relationVo.setType(costBudgetVo.getType());
        }
        return Lists.newArrayList((Iterable)activitiesSchemeRelationVos);
    }

    @Override
    public List<ActivitiesSchemeRelationVo> findByActivityCodes(Set<String> activityCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        List<ActivitiesSchemeRelation> activitiesSchemeRelations = this.activitiesSchemeRelationRepository.findByActivityCodesAndTenantCode(activityCodes, tenantCode);
        Collection activitiesSchemeRelationVos = this.nebulaToolkitService.copyCollectionByWhiteList(activitiesSchemeRelations, ActivitiesSchemeRelation.class, ActivitiesSchemeRelationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)activitiesSchemeRelationVos);
    }

    @Override
    @Transactional
    public void removeByIds(Collection<String> ids) {
        this.activitiesSchemeRelationRepository.removeByIds(ids);
    }

    private void createValidate(ActivitiesSchemeRelationVo activitiesSchemeRelationVo) {
        Validate.notNull((Object)((Object)activitiesSchemeRelationVo), (String)"\u65b9\u6848\u6d3b\u52a8\u5173\u8054\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesSchemeRelationVo.getActivityCode(), (String)"\u65b9\u6848\u6d3b\u52a8\u5173\u8054\u6570\u636e\u6d3b\u52a8\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesSchemeRelationVo.getCostBudgetCode(), (String)"\u65b9\u6848\u6d3b\u52a8\u5173\u8054\u6570\u636e\u9884\u7b97\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }
}

