/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.service.internal;

import com.biz.crm.tpm.business.activities.scheme.entity.SchemeProduct;
import com.biz.crm.tpm.business.activities.scheme.repository.SchemeProductRepository;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeProductVoService;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="schemeProductVoService")
public class SchemeProductVoServiceImpl
implements SchemeProductVoService {
    @Autowired
    private SchemeProductRepository schemeProductRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Set<SchemeProductVo> findBySchemeCode(String schemeCode) {
        if (StringUtils.isBlank((CharSequence)schemeCode)) {
            return null;
        }
        List<SchemeProduct> schemeProducts = this.schemeProductRepository.findBySchemeCode(schemeCode);
        if (CollectionUtils.isEmpty(schemeProducts)) {
            return null;
        }
        Collection schemeProductVos = this.nebulaToolkitService.copyCollectionByWhiteList(schemeProducts, SchemeProduct.class, SchemeProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet((Iterable)schemeProductVos);
    }

    @Override
    @Transactional
    public SchemeProductVo create(SchemeProductVo schemeProductVo) {
        this.createValidate(schemeProductVo);
        SchemeProduct schemeProduct = (SchemeProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)schemeProductVo, SchemeProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        schemeProduct.setTenantCode(TenantUtils.getTenantCode());
        this.schemeProductRepository.saveOrUpdate((Object)schemeProduct);
        return schemeProductVo;
    }

    @Override
    @Transactional
    public void deleteBySchemeCode(String schemeCode) {
        Validate.notBlank((CharSequence)schemeCode, (String)"\u5220\u9664\u65b9\u6848\u5546\u54c1\u6570\u636e\uff0c\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.schemeProductRepository.deleteBySchemeCode(schemeCode);
    }

    private void createValidate(SchemeProductVo schemeProductVo) {
        Validate.notNull((Object)schemeProductVo, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        schemeProductVo.setId(null);
        Validate.notBlank((CharSequence)schemeProductVo.getProductCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeProductVo.getProductName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeProductVo.getSchemeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

