/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.scheme.service.internal;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activities.scheme.dto.SchemeRangeDto;
import com.biz.crm.tpm.business.activities.scheme.entity.SchemeRange;
import com.biz.crm.tpm.business.activities.scheme.repository.SchemeRangeRepository;
import com.biz.crm.tpm.business.activities.scheme.service.SchemeRangeVoService;
import com.biz.crm.tpm.business.activities.scheme.vo.SchemeRangeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemeRangeVoService")
public class SchemeRangeVoServiceImpl
implements SchemeRangeVoService {
    @Autowired
    private SchemeRangeRepository schemeRangeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Set<SchemeRangeVo> findBySchemeCode(String schemeCode) {
        List<SchemeRange> schemeRanges = this.schemeRangeRepository.findBySchemeCode(schemeCode);
        Collection schemeRangeVos = this.nebulaToolkitService.copyCollectionByWhiteList(schemeRanges, SchemeRange.class, SchemeRangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet((Iterable)schemeRangeVos);
    }

    @Override
    public Set<SchemeRangeVo> findAll() {
        List<SchemeRange> schemeRanges = this.schemeRangeRepository.findAll();
        Collection schemeRangeVos = this.nebulaToolkitService.copyCollectionByWhiteList(schemeRanges, SchemeRange.class, SchemeRangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet((Iterable)schemeRangeVos);
    }

    @Override
    @Transactional
    public SchemeRangeVo create(SchemeRangeVo schemeRangeVo) {
        this.createValidate(schemeRangeVo);
        SchemeRange schemeRange = (SchemeRange)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)schemeRangeVo, SchemeRange.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        schemeRange.setTenantCode(TenantUtils.getTenantCode());
        schemeRange.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.schemeRangeRepository.saveOrUpdate((Object)schemeRange);
        return schemeRangeVo;
    }

    @Override
    @Transactional
    public SchemeRangeVo update(SchemeRangeDto schemeRangeDto) {
        this.updateValidate(schemeRangeDto);
        SchemeRange schemeRange = (SchemeRange)((Object)this.schemeRangeRepository.getById((Serializable)((Object)schemeRangeDto.getId())));
        Validate.notNull((Object)((Object)schemeRange), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        schemeRange.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.schemeRangeRepository.saveOrUpdate((Object)schemeRange);
        SchemeRangeVo schemeRangeVo = (SchemeRangeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)schemeRange, SchemeRangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return schemeRangeVo;
    }

    @Override
    public void deleteBySchemeCode(String schemeCode) {
        Validate.notBlank((CharSequence)schemeCode, (String)"\u5220\u9664\u65b9\u6848\u8303\u56f4\u6570\u636e\uff0c\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.schemeRangeRepository.deleteBySchemeCode(schemeCode);
    }

    @Override
    public void deleteByRangeCodes(Collection<String> codes) {
        this.schemeRangeRepository.deleteByRangeCodes(codes);
    }

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u542f\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<SchemeRange> schemeRanges = this.schemeRangeRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(schemeRanges)) {
            return;
        }
        Collection schemeRangeVos = this.nebulaToolkitService.copyCollectionByWhiteList(schemeRanges, SchemeRange.class, SchemeRangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.schemeRangeRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<SchemeRange> schemeRanges = this.schemeRangeRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(schemeRanges)) {
            return;
        }
        Collection schemeRangeVos = this.nebulaToolkitService.copyCollectionByWhiteList(schemeRanges, SchemeRange.class, SchemeRangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.schemeRangeRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    public void updateEnableStatus(Set<String> codes, String enableStatus) {
        List<SchemeRange> schemeRanges = this.schemeRangeRepository.findByCodes(codes);
        if (CollectionUtils.isEmpty(schemeRanges)) {
            return;
        }
        codes = schemeRanges.stream().map(SchemeRange::getRangeCode).collect(Collectors.toSet());
        this.schemeRangeRepository.updateEnableStatusByCodes(EnableStatusEnum.codeToEnum((String)enableStatus), codes);
    }

    private void createValidate(SchemeRangeVo schemeRangeVo) {
        Validate.notNull((Object)schemeRangeVo, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        schemeRangeVo.setId(null);
        Validate.notBlank((CharSequence)schemeRangeVo.getSchemeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65b9\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)schemeRangeVo.getRangeType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8303\u56f4\u7c7b\u578b(1,\u7ec4\u7ec7,2,\u7ec4\u7ec7\u7c7b\u578b)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeRangeVo.getRangeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8303\u56f4\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeRangeVo.getRangeName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8303\u56f4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(SchemeRangeDto schemeRangeDto) {
        Validate.notNull((Object)schemeRangeDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)schemeRangeDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

