/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.dynamic.template.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.DynamicFormServiceBuilder;
import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeCategoryVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeCategoryVo;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DynamicFormServiceResolver {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CostTypeCategoryVoService costTypeCategoryVoService;
    @Autowired(required=false)
    private List<DynamicFormOperationStrategy> dynamicFormOperationStrategies;

    public <T> Set<DynamicFormService<T>> getDynamicFormServices(JSONObject json, String dynamicFormField, Class<T> mainClass) {
        if (StringUtils.isBlank((CharSequence)dynamicFormField) || json == null || json.size() == 0 || mainClass == null) {
            return null;
        }
        JSONObject itemJsons = json.getJSONObject(dynamicFormField);
        if (itemJsons == null || itemJsons.size() == 0) {
            return null;
        }
        HashSet dynamicFormServices = Sets.newHashSet();
        Set dynamicKeys = itemJsons.keySet();
        for (String dynamicKey : dynamicKeys) {
            if (itemJsons.get((Object)dynamicKey) == null || itemJsons.getJSONArray(dynamicKey).size() == 0) continue;
            this.regularDynamicKey(dynamicKey);
            String costTypeCategoryCode = StringUtils.split((String)dynamicKey, (String)":")[1];
            CostTypeCategoryVo costTypeCategoryVo = this.costTypeCategoryVoService.findByCode(costTypeCategoryCode);
            if (costTypeCategoryVo == null) {
                return null;
            }
            String dynamicFormCode = costTypeCategoryVo.getFormCode();
            DynamicFormServiceBuilder builder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{mainClass, this.applicationContext});
            DynamicFormService e = builder.dynamicField(dynamicFormField).addDynamicMapping(dynamicKey, dynamicFormCode).config().build();
            dynamicFormServices.add(e);
        }
        return dynamicFormServices;
    }

    public <T> Set<DynamicFormService<T>> getDynamicFormServices(JSONObject json, String dynamicFormField, String dynamicFormCode, Class<T> mainClass) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dynamicFormField, dynamicFormCode}) || json == null || json.size() == 0 || mainClass == null) {
            return null;
        }
        JSONObject itemJsons = json.getJSONObject(dynamicFormField);
        if (itemJsons == null || itemJsons.size() == 0) {
            return null;
        }
        DynamicFormServiceBuilder builder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{mainClass, this.applicationContext});
        Set dynamicKeys = itemJsons.keySet();
        HashSet dynamicFormServices = Sets.newHashSet();
        for (String dynamicKey : dynamicKeys) {
            if (itemJsons.get((Object)dynamicKey) == null || itemJsons.getJSONArray(dynamicKey).size() == 0) continue;
            this.regularDynamicKey(dynamicKey);
            DynamicFormService e = builder.dynamicField(dynamicFormField).addDynamicMapping(dynamicKey, dynamicFormCode).config().build();
            dynamicFormServices.add(e);
        }
        return dynamicFormServices;
    }

    public <T> DynamicFormService<T> getDynamicFormService(String parentCode, String dynamicFormCode, String dynamicFormField, Class<T> mainClass) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dynamicFormField, parentCode, dynamicFormCode}) || mainClass == null) {
            return null;
        }
        DynamicFormServiceBuilder builder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{mainClass, this.applicationContext});
        return builder.dynamicField(dynamicFormField).addDynamicMapping(parentCode, dynamicFormCode).config().build();
    }

    public <T> DynamicFormService<T> getDynamicFormService(String dynamicKey, String dynamicFormField, Class<T> mainClass) {
        if (StringUtils.isBlank((CharSequence)dynamicFormField) || mainClass == null) {
            return null;
        }
        this.regularDynamicKey(dynamicKey);
        String costTypeCategoryCode = StringUtils.split((String)dynamicKey, (String)":")[1];
        CostTypeCategoryVo costTypeCategoryVo = this.costTypeCategoryVoService.findByCode(costTypeCategoryCode);
        if (costTypeCategoryVo == null) {
            return null;
        }
        String dynamicFormCode = costTypeCategoryVo.getFormCode();
        DynamicFormServiceBuilder builder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{mainClass, this.applicationContext});
        return builder.dynamicField(dynamicFormField).addDynamicMapping(dynamicKey, dynamicFormCode).config().build();
    }

    public Class<? extends OperationStrategy> getDynamicFormClass(String dynamicFormCode) {
        if (StringUtils.isBlank((CharSequence)dynamicFormCode) || CollectionUtils.isEmpty(this.dynamicFormOperationStrategies)) {
            return null;
        }
        DynamicFormOperationStrategy strategy = null;
        for (DynamicFormOperationStrategy dynamicFormOperationStrategy : this.dynamicFormOperationStrategies) {
            if (!StringUtils.equals((CharSequence)dynamicFormOperationStrategy.dynamicFormCode(), (CharSequence)dynamicFormCode)) continue;
            strategy = dynamicFormOperationStrategy;
            break;
        }
        if (strategy == null) {
            return null;
        }
        return strategy.dynamicFormClass();
    }

    private void regularDynamicKey(String dynamicKey) {
        String pattern = "^[A-Z]{1}[A-Z0-9]*[:]{1}[A-Z]{1}[A-Z0-9]*$";
        Validate.matchesPattern((CharSequence)dynamicKey, (String)pattern, (String)"\u5916\u754c\u4f20\u5165\u7684dynamicKey\u683c\u5f0f\u975e\u6cd5\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u5f62\u5982\u3010FEE001:AD0001\u3011\uff0c\u7531\u5927\u5199\u5b57\u6bcd\u53ca\u6570\u5b57\u7ec4\u6210\uff0c\u4e14\u4e2d\u95f4\u7531:\u53f7\u62fc\u63a5\uff0c\u4e0d\u80fd\u542b\u6709\u5176\u5b83\u7279\u6b8a\u5b57\u7b26", (Object[])new Object[0]);
    }
}

