/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.dynamic.template.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.activities.dynamic.template.entity.ActivityProductShareInfo;
import com.biz.crm.tpm.business.activities.dynamic.template.repository.ActivityProductShareInfoRepository;
import com.biz.crm.tpm.business.activities.dynamic.template.service.ActivityProductShareInfoService;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.ActivityProductShareInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityProductShareInfoServiceImpl
implements ActivityProductShareInfoService {
    @Autowired
    private ActivityProductShareInfoRepository activityProductShareInfoRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void save(List<ActivityProductShareInfo> shareInfos) {
        Validate.notEmpty(shareInfos, (String)"\u6d3b\u52a8\u660e\u7ec6\u5546\u54c1\u5206\u644a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ActivityProductShareInfo shareInfo : shareInfos) {
            Validate.notBlank((CharSequence)shareInfo.getAssociateId(), (String)"\u5173\u8054\u7684\u6d3b\u52a8\u660e\u7ec6id\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)shareInfo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)shareInfo.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)shareInfo.getRatio(), (String)"\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((shareInfo.getRatio().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
            if (!StringUtils.isBlank((CharSequence)shareInfo.getTenantCode())) continue;
            shareInfo.setTenantCode(TenantUtils.getTenantCode());
        }
        long size = shareInfos.stream().map(ActivityProductShareInfo::getAssociateId).distinct().count();
        Validate.isTrue((1L == size ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u660e\u7ec6\u5546\u54c1\u5206\u644a\u4fe1\u606f\u542b\u6709\u591a\u4e2a\u4e0d\u540c\u7684\u6d3b\u52a8\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5associateId\u952e\u503c", (Object[])new Object[0]);
        long productSize = shareInfos.stream().map(ActivityProductShareInfo::getProductCode).distinct().count();
        Validate.isTrue((productSize == (long)shareInfos.size() ? 1 : 0) != 0, (String)"\u5206\u644a\u7684\u4ea7\u54c1\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        BigDecimal totalRatio = shareInfos.stream().map(ActivityProductShareInfo::getRatio).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((totalRatio.compareTo(BigDecimal.valueOf(100L)) == 0 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u7684\u5206\u644a\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u4e3a100", (Object[])new Object[0]);
        List<ActivityProductShareInfo> dbShareInfos = this.activityProductShareInfoRepository.findByAssociateId(shareInfos.get(0).getAssociateId());
        if (!CollectionUtils.isEmpty(dbShareInfos)) {
            this.activityProductShareInfoRepository.removeByIds(dbShareInfos.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        }
        this.activityProductShareInfoRepository.saveBatch(shareInfos);
    }

    @Override
    public List<ActivityProductShareInfoVo> findByAssociateIds(Set<String> associateIds) {
        if (CollectionUtils.isEmpty(associateIds)) {
            return Lists.newArrayList();
        }
        List<ActivityProductShareInfo> shareInfos = this.activityProductShareInfoRepository.findByAssociateIds(associateIds);
        if (CollectionUtils.isEmpty(shareInfos)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(shareInfos, ActivityProductShareInfo.class, ActivityProductShareInfoVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    @Transactional
    public void deleteByAssociateIds(Set<String> associateIds) {
        Validate.notEmpty(associateIds, (String)"\u5173\u8054\u7684\u6d3b\u52a8\u660e\u7ec6id\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.activityProductShareInfoRepository.deleteByAssociateIds(associateIds);
    }
}

