/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.dynamic.template.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activities.dynamic.template.entity.BanquetTemplate;
import com.biz.crm.tpm.business.activities.dynamic.template.enums.BanquetTypeEnum;
import com.biz.crm.tpm.business.activities.dynamic.template.enums.LiquorTypeEnum;
import com.biz.crm.tpm.business.activities.dynamic.template.repository.BanquetTemplateRepository;
import com.biz.crm.tpm.business.activities.dynamic.template.service.BanquetTemplateService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BanquetTemplateServiceImpl
implements BanquetTemplateService {
    @Autowired
    private BanquetTemplateRepository banquetTemplateRepository;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional
    public void create(BanquetTemplate item) {
        this.validate(item);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)item.getId()), (String)"\u65b0\u589e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        item.setId(null);
        String ruleCode = StringUtils.join((Object[])new String[]{"BQMX", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        item.setItemCode((String)codeList.get(0));
        this.banquetTemplateRepository.save((Object)item);
    }

    @Override
    @Transactional
    public void update(BanquetTemplate banquetTemplate) {
        Validate.notNull((Object)((Object)banquetTemplate), (String)"\u901a\u7528\u91c7\u96c6\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validate(banquetTemplate);
        String parentCode = banquetTemplate.getParentCode();
        BanquetTemplate dbBanquetTemplate = this.banquetTemplateRepository.findByParentCodeAndTenantCode(parentCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)dbBanquetTemplate), (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u8868\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{parentCode});
        dbBanquetTemplate.setLabel(banquetTemplate.getLabel());
        dbBanquetTemplate.setBanquetDate(banquetTemplate.getBanquetDate());
        dbBanquetTemplate.setLiquorTypes(banquetTemplate.getLiquorTypes());
        dbBanquetTemplate.setNormal(banquetTemplate.getNormal());
        dbBanquetTemplate.setPeoples(banquetTemplate.getPeoples());
        dbBanquetTemplate.setType(banquetTemplate.getType());
        this.banquetTemplateRepository.saveOrUpdate((Object)dbBanquetTemplate);
    }

    @Override
    @Transactional
    public void deleteByParentCode(String parentCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u4e3b\u6d3b\u52a8\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BanquetTemplate banquetTemplate = this.banquetTemplateRepository.findByParentCodeAndTenantCode(parentCode, TenantUtils.getTenantCode());
        if (banquetTemplate == null) {
            return;
        }
        this.banquetTemplateRepository.removeById((Serializable)((Object)banquetTemplate.getId()));
    }

    private void validate(BanquetTemplate item) {
        Validate.notNull((Object)((Object)item), (String)"\u901a\u7528\u91c7\u96c6\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getParentCode(), (String)"\u4e3b\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getDynamicKey(), (String)"\u4e1a\u52a1key\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)item.getBanquetDate(), (String)"\u5bb4\u4f1a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)item.getPeoples(), (String)"\u5bb4\u4f1a\u4eba\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getType(), (String)"\u5bb4\u4f1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)item.getType())) {
            Validate.isTrue((boolean)BanquetTypeEnum.contains(item.getType()), (String)"\u5bb4\u4f1a\u7c7b\u578b\u679a\u4e3e\u503c\u3010%s\u3011\u4e0d\u5339\u914d", (Object[])new Object[]{item.getType()});
        }
        if (StringUtils.isNotBlank((CharSequence)item.getLiquorTypes())) {
            String[] liquorTypes;
            for (String liquorType : liquorTypes = StringUtils.split((String)item.getLiquorTypes(), (String)",")) {
                Validate.isTrue((boolean)LiquorTypeEnum.contains(liquorType), (String)"\u9152\u7c7b\u7528\u54c1\u679a\u4e3e\u503c\u3010%s\u3011\u4e0d\u5339\u914d", (Object[])new Object[]{item.getType()});
            }
        }
        if (StringUtils.isBlank((CharSequence)item.getTenantCode())) {
            item.setTenantCode(TenantUtils.getTenantCode());
        }
    }
}

