/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.dynamic.template.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activities.dynamic.template.entity.GeneralTemplate;
import com.biz.crm.tpm.business.activities.dynamic.template.repository.GeneralTemplateRepository;
import com.biz.crm.tpm.business.activities.dynamic.template.service.GeneralTemplateService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneralTemplateServiceImpl
implements GeneralTemplateService {
    @Autowired
    private GeneralTemplateRepository generalTemplateRepository;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional
    public void create(GeneralTemplate item) {
        this.validate(item);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)item.getId()), (String)"\u65b0\u589e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        item.setId(null);
        String ruleCode = StringUtils.join((Object[])new String[]{"GTMX", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        item.setItemCode((String)codeList.get(0));
        this.generalTemplateRepository.save((Object)item);
    }

    @Override
    @Transactional
    public void update(GeneralTemplate generalTemplate) {
        Validate.notNull((Object)((Object)generalTemplate), (String)"\u901a\u7528\u91c7\u96c6\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validate(generalTemplate);
        String parentCode = generalTemplate.getParentCode();
        GeneralTemplate dbGeneralTemplate = this.generalTemplateRepository.findByParentCodeAndTenantCode(parentCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)dbGeneralTemplate), (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u8868\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{parentCode});
        dbGeneralTemplate.setLabel(generalTemplate.getLabel());
        dbGeneralTemplate.setExecutionDate(generalTemplate.getExecutionDate());
        dbGeneralTemplate.setExecutionRecord(generalTemplate.getExecutionRecord());
        dbGeneralTemplate.setNormal(generalTemplate.getNormal());
        this.generalTemplateRepository.saveOrUpdate((Object)dbGeneralTemplate);
    }

    @Override
    @Transactional
    public void deleteByParentCode(String parentCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u4e3b\u6d3b\u52a8\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        GeneralTemplate generalTemplate = this.generalTemplateRepository.findByParentCodeAndTenantCode(parentCode, TenantUtils.getTenantCode());
        if (generalTemplate == null) {
            return;
        }
        this.generalTemplateRepository.removeById((Serializable)((Object)generalTemplate.getId()));
    }

    private void validate(GeneralTemplate item) {
        Validate.notNull((Object)((Object)item), (String)"\u901a\u7528\u91c7\u96c6\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getParentCode(), (String)"\u4e3b\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getDynamicKey(), (String)"\u4e1a\u52a1key\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)item.getExecutionDate(), (String)"\u6267\u884c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getExecutionRecord(), (String)"\u6267\u884c\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)item.getNormal(), (String)"\u662f\u5426\u6b63\u5e38\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)item.getTenantCode())) {
            item.setTenantCode(TenantUtils.getTenantCode());
        }
    }
}

