/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.dynamic.template.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.form.sdk.context.DynamicFormContext;
import com.biz.crm.common.form.sdk.context.DynamicFormContextHolder;
import com.biz.crm.tpm.business.activities.dynamic.template.entity.MaterialActivityItem;
import com.biz.crm.tpm.business.activities.dynamic.template.repository.MaterialActivityItemRepository;
import com.biz.crm.tpm.business.activities.dynamic.template.service.ActivityProductShareInfoService;
import com.biz.crm.tpm.business.activities.dynamic.template.service.MaterialActivityItemService;
import com.biz.crm.tpm.business.activities.dynamic.template.strategy.DynamicFormsOperationStrategyForMaterialActivityItem;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.MaterialActivityItemVo;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesShareDto;
import com.biz.crm.tpm.business.activities.sdk.strategy.share.ActivitiesShareStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialActivityItemServiceImpl
implements MaterialActivityItemService,
ActivitiesShareStrategy {
    @Autowired
    private MaterialActivityItemRepository materialActivityItemRepository;
    @Autowired
    private ActivityProductShareInfoService activityProductShareInfoService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void create(MaterialActivityItem item) {
        this.validate(item);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)item.getId()), (String)"\u65b0\u589e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        item.setId(null);
        String ruleCode = StringUtils.join((Object[])new String[]{"WLMX", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        item.setItemCode((String)codeList.get(0));
        this.processDynamicFormContextForCreateOrUpdate(item);
        this.materialActivityItemRepository.save((Object)item);
        if (!CollectionUtils.isEmpty(item.getShareInfos())) {
            item.getShareInfos().forEach(e -> e.setAssociateId(item.getId()));
            this.activityProductShareInfoService.save(item.getShareInfos());
        }
    }

    @Override
    @Transactional
    public void update(Collection<MaterialActivityItem> items) {
        List needAdds;
        Set needUpdates;
        Validate.notEmpty(items, (String)"\u7269\u6599\u9886\u7528\u6d3b\u52a8\u52a8\u6001\u6a21\u677f\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        items.forEach(this::validate);
        MaterialActivityItem materialActivityItem = items.iterator().next();
        String parentCode = materialActivityItem.getParentCode();
        String dynamicKey = materialActivityItem.getDynamicKey();
        Set currentIds = items.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).map(UuidEntity::getId).collect(Collectors.toSet());
        List<MaterialActivityItem> dbItems = this.materialActivityItemRepository.findByDynamicKeyAndParentCodeAndTenantCode(dynamicKey, parentCode, TenantUtils.getTenantCode());
        Validate.notEmpty(dbItems, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u8868\u7f16\u7801\u3010%s\u3011\u548c\u52a8\u6001\u6a21\u677f\u660e\u7ec6\u952e\u503c\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{parentCode, dynamicKey});
        Set dbIds = dbItems.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        Sets.SetView needDeletes = Sets.difference(dbIds, currentIds);
        if (!CollectionUtils.isEmpty((Collection)needDeletes)) {
            this.activityProductShareInfoService.deleteByAssociateIds((Set<String>)needDeletes);
            this.materialActivityItemRepository.removeByIds((Collection)needDeletes);
        }
        if (!CollectionUtils.isEmpty(needUpdates = items.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toSet()))) {
            for (MaterialActivityItem item : needUpdates) {
                MaterialActivityItem dbItem = dbItems.stream().filter(e -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)item.getId())).findFirst().orElse(null);
                Validate.notNull((Object)((Object)dbItem), (String)"\u672a\u80fd\u5339\u914d\u5230\u76f8\u5e94\u7684\u7269\u6599\u9886\u7528\u6d3b\u52a8\u52a8\u6001\u6a21\u677f\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                this.processDynamicFormContextForCreateOrUpdate(item);
                dbItem.setApplyAmount(item.getApplyAmount());
                dbItem.setLabel(item.getLabel());
                dbItem.setCostBudgetCode(item.getCostBudgetCode());
                dbItem.setCostTypeCategoryCode(item.getCostTypeCategoryCode());
                dbItem.setCostTypeCategoryName(item.getCostTypeCategoryName());
                dbItem.setCostTypeDetailCode(item.getCostTypeDetailCode());
                dbItem.setCostTypeDetailName(item.getCostTypeDetailName());
                dbItem.setBudgetSubjectsCode(item.getBudgetSubjectsCode());
                dbItem.setBudgetSubjectsName(item.getBudgetSubjectsName());
                dbItem.setCustomerCode(item.getCustomerCode());
                dbItem.setCustomerName(item.getCustomerName());
                dbItem.setCostPrice(item.getCostPrice());
                dbItem.setMaterialCode(item.getMaterialCode());
                dbItem.setMaterialName(item.getMaterialName());
                dbItem.setQuantity(item.getQuantity());
                dbItem.setFeeDate(item.getFeeDate());
                dbItem.setOrgCode(item.getOrgCode());
                dbItem.setOrgName(item.getOrgName());
                dbItem.setPayType(item.getPayType());
                dbItem.setPayTypeName(item.getPayTypeName());
                dbItem.setRemark(item.getRemark());
                dbItem.setTerminalCode(item.getTerminalCode());
                dbItem.setTerminalName(item.getTerminalName());
                dbItem.setShareKey(item.getShareKey());
                this.materialActivityItemRepository.saveOrUpdate((Object)dbItem);
                if (CollectionUtils.isEmpty(item.getShareInfos())) continue;
                item.getShareInfos().forEach(e -> e.setAssociateId(item.getId()));
                this.activityProductShareInfoService.save(item.getShareInfos());
            }
        }
        if (!CollectionUtils.isEmpty(needAdds = items.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toList()))) {
            for (MaterialActivityItem needAdd : needAdds) {
                this.create(needAdd);
            }
        }
    }

    @Override
    @Transactional
    public void deleteByParentCode(String parentCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u4e3b\u6d3b\u52a8\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MaterialActivityItem> materialActivityItems = this.materialActivityItemRepository.findByParentCodeAndTenantCode(parentCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(materialActivityItems)) {
            return;
        }
        this.materialActivityItemRepository.removeByIds(materialActivityItems.stream().map(UuidEntity::getId).collect(Collectors.toList()));
    }

    private void validate(MaterialActivityItem item) {
        Validate.notNull((Object)((Object)item), (String)"\u7269\u6599\u9886\u7528\u6d3b\u52a8\u52a8\u6001\u6a21\u677f\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getParentCode(), (String)"\u4e3b\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getDynamicKey(), (String)"\u4e1a\u52a1key\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getCostBudgetCode(), (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getCostTypeCategoryCode(), (String)"\u6d3b\u52a8\u5927\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getCostTypeCategoryName(), (String)"\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getCostTypeDetailCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getCostTypeDetailName(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getBudgetSubjectsCode(), (String)"\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getBudgetSubjectsName(), (String)"\u9884\u7b97\u79d1\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getMaterialName(), (String)"\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)item.getQuantity(), (String)"\u9886\u7528\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)item.getCostPrice(), (String)"\u6210\u672c\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validateCustomer(item);
        this.validateTerminal(item);
        Validate.isTrue((item.getApplyAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u9886\u7528\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((new BigDecimal(item.getQuantity().intValue()).compareTo(item.getQuantity()) == 0 ? 1 : 0) != 0, (String)"\u9886\u7528\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570", (Object[])new Object[0]);
        Validate.isTrue((item.getCostPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6210\u672c\u4ef7\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getPayType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getPayTypeName(), (String)"\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)item.getFeeDate(), (String)"\u8d39\u7528\u65e5\u671f(\u5e74\u6708)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)item.getTenantCode())) {
            item.setTenantCode(TenantUtils.getTenantCode());
        }
    }

    private void validateCustomer(MaterialActivityItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getCustomerCode()) || StringUtils.isNotBlank((CharSequence)item.getCustomerName())) {
            Validate.notBlank((CharSequence)item.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void validateTerminal(MaterialActivityItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getTerminalCode()) || StringUtils.isNotBlank((CharSequence)item.getTerminalName())) {
            Validate.notBlank((CharSequence)item.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void validateFeeDate(MaterialActivityItem item, DynamicFormContext context) {
        if (context.exist("startTime") && context.exist("endTime")) {
            Date startTime = (Date)context.get("startTime");
            Date endTime = (Date)context.get("endTime");
            String startTimeStr = DateFormatUtils.format((Date)startTime, (String)"yyyy-MM");
            String endTimeStr = DateFormatUtils.format((Date)endTime, (String)"yyyy-MM");
            Validate.matchesPattern((CharSequence)item.getFeeDate(), (String)"^2[0-1]{1}[0-9]{1}[0-9]{1}[-]{1}[0-1]{1}[0-9]{1}$", (String)"\u8d39\u7528\u5e74\u6708\u4e0d\u6ee1\u8db3yyyy-MM\u683c\u5f0f", (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)item.getShareKey())) {
                Validate.isTrue((StringUtils.compare((String)startTimeStr, (String)item.getFeeDate()) == 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7684\u5f00\u59cb\u65e5\u671f\u4e0e\u660e\u7ec6\u6708\u4efd\u4e0d\u4e00\u81f4\uff0c\u8d39\u7528\u5e74\u6708\u9700\u6ee1\u8db3yyyy-MM\u683c\u5f0f", (Object[])new Object[0]);
            } else {
                Validate.isTrue((StringUtils.compare((String)startTimeStr, (String)item.getFeeDate()) <= 0 && StringUtils.compare((String)endTimeStr, (String)item.getFeeDate()) >= 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u5e74\u6708\u4e0d\u5728\u6d3b\u52a8\u65f6\u95f4\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            }
        }
    }

    private void processDynamicFormContextForCreateOrUpdate(MaterialActivityItem item) {
        DynamicFormContext context = DynamicFormContextHolder.getContext();
        this.validateFeeDate(item, context);
        if (context.exist("sumTotalApplyAmount")) {
            BigDecimal totalApplyAmount = (BigDecimal)context.get("sumTotalApplyAmount");
            context.put("sumTotalApplyAmount", (Object)totalApplyAmount.add(item.getApplyAmount()));
        }
    }

    public String dynamicFormCode() {
        return DynamicFormsOperationStrategyForMaterialActivityItem.MATERIAL_ACTIVITY_ITEM_OPERATION_STRATEGY_KEY;
    }

    public List<?> share(ActivitiesShareDto dto) {
        Validate.notNull((Object)dto, (String)"\u4f20\u5165\u7684\u5f85\u5206\u644a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date startTime = dto.getStartTime();
        Date endTime = dto.getEndTime();
        String dynamicFormCode = dto.getDynamicFormCode();
        JSONObject dynamicForm = dto.getDynamicForm();
        Validate.notNull((Object)startTime, (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)endTime, (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u52a8\u6001\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Map)dynamicForm, (String)"\u52a8\u6001\u8868\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MaterialActivityItemVo itemVo = (MaterialActivityItemVo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dynamicForm), MaterialActivityItemVo.class));
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)itemVo.getFeeDate()), (String)"\u52a8\u6001\u8868\u5355\u4fe1\u606f\u4e2d\uff0c\u8d39\u7528\u5e74\u6708\u4e0d\u80fd\u6709\u503c\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String startTimeStr = DateFormatUtils.format((Date)startTime, (String)"yyyy-MM");
        String endTimeStr = DateFormatUtils.format((Date)endTime, (String)"yyyy-MM");
        boolean crossMonth = !StringUtils.equals((CharSequence)startTimeStr, (CharSequence)endTimeStr);
        Validate.isTrue((boolean)crossMonth, (String)"\u6d3b\u52a8\u65f6\u95f4\u8303\u56f4\u4e0d\u5b58\u5728\u8de8\u6708\u60c5\u51b5\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u644a", (Object[])new Object[0]);
        LinkedList times = Lists.newLinkedList();
        LinkedList amounts = Lists.newLinkedList();
        this.dismantleTimes(startTime, endTimeStr, times);
        this.dismantleAmount(itemVo.getApplyAmount(), times.size(), amounts);
        ArrayList result = Lists.newArrayList();
        String shareKey = String.valueOf(System.currentTimeMillis());
        for (String time : times) {
            MaterialActivityItemVo copy = (MaterialActivityItemVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)itemVo, MaterialActivityItemVo.class, HashSet.class, ArrayList.class, new String[0]));
            copy.setItemCode(null);
            copy.setId(null);
            copy.setShareKey(shareKey);
            copy.setFeeDate(time);
            copy.setApplyAmount((BigDecimal)amounts.poll());
            result.add(copy);
        }
        return result;
    }

    private void dismantleTimes(Date startTime, String endTimeStr, List<String> times) {
        String startTimeStr = DateFormatUtils.format((Date)startTime, (String)"yyyy-MM");
        if (StringUtils.compare((String)startTimeStr, (String)endTimeStr) >= 0) {
            times.add(endTimeStr);
            return;
        }
        times.add(DateFormatUtils.format((Date)startTime, (String)"yyyy-MM"));
        this.dismantleTimes(DateUtils.addMonths((Date)startTime, (int)1), endTimeStr, times);
    }

    private void dismantleAmount(BigDecimal applyAmount, int size, List<BigDecimal> amounts) {
        Validate.notNull((Object)applyAmount, (String)"\u6307\u5b9a\u7684\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((applyAmount.compareTo(new BigDecimal("0.01").multiply(BigDecimal.valueOf(size))) >= 0 ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u7533\u8bf7\u91d1\u989d\u3010%s\u3011\u4e0d\u6ee1\u8db3\u6700\u5c0f\u5206\u644a\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{applyAmount.toString()});
        BigDecimal shareAmount = applyAmount.divide(BigDecimal.valueOf(size), 2, RoundingMode.DOWN);
        for (int index = 0; index < size - 1; ++index) {
            amounts.add(shareAmount);
        }
        BigDecimal shareAmounts = amounts.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal lastShareAmount = applyAmount.subtract(shareAmounts);
        amounts.add(lastShareAmount);
    }
}

