/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.dynamic.template.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.tpm.business.activities.dynamic.template.entity.BanquetTemplate;
import com.biz.crm.tpm.business.activities.dynamic.template.repository.BanquetTemplateRepository;
import com.biz.crm.tpm.business.activities.dynamic.template.service.BanquetTemplateService;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.BanquetTemplateVo;
import com.biz.crm.tpm.business.activities.sdk.register.BudgetCenterModuleRegister;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicFormOperationStrategyForBanquetTemplate
implements DynamicFormOperationStrategy<BanquetTemplateVo> {
    public static final String BANQUET_TEMPLATE_OPERATION_STRATEGY_KEY = StringUtils.uncapitalize((String)DynamicFormOperationStrategyForBanquetTemplate.class.getSimpleName());
    @Autowired
    private BudgetCenterModuleRegister budgetCenterModuleRegister;
    @Autowired
    private BanquetTemplateService banquetTemplateService;
    @Autowired
    private BanquetTemplateRepository banquetTemplateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormOperationStrategyForBanquetTemplate.class);

    public int getOrder() {
        return 12;
    }

    public String dynamicFormCode() {
        return BANQUET_TEMPLATE_OPERATION_STRATEGY_KEY;
    }

    public String dynamicFormName() {
        return "\u793a\u4f8b\u7528-\u5bb4\u4f1a\u91c7\u96c6\u6a21\u677f\uff08\u52a8\u6001\u8868\u5355\uff09";
    }

    public Class<BanquetTemplateVo> dynamicFormClass() {
        return BanquetTemplateVo.class;
    }

    public String moduleCode() {
        return this.budgetCenterModuleRegister.moduleCode();
    }

    public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
        this.banquetTemplateService.deleteByParentCode(parentCode);
    }

    public void onDynamicFormCreate(BanquetTemplateVo dynamicForm, String dynamicKey, String parentCode, Object parent) {
        Validate.notNull((Object)((Object)dynamicForm), (String)"\u5bb4\u4f1a\u91c7\u96c6\u52a8\u6001\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dynamicForm.getId()), (String)"\u5bb4\u4f1a\u91c7\u96c6\u52a8\u6001\u6a21\u677fid\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        BanquetTemplateVo item = (BanquetTemplateVo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)dynamicForm)), BanquetTemplateVo.class));
        item.setId(null);
        item.setParentCode(parentCode);
        item.setDynamicKey(dynamicKey);
        item.setDynamicFormCode(BANQUET_TEMPLATE_OPERATION_STRATEGY_KEY);
        BanquetTemplate entity = (BanquetTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, BanquetTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        this.banquetTemplateService.create(entity);
    }

    public void onDynamicFormModify(BanquetTemplateVo dynamicForm, String dynamicKey, String parentCode, Object parent) {
        Validate.notNull((Object)((Object)dynamicForm), (String)"\u5bb4\u4f1a\u91c7\u96c6\u52a8\u6001\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicForm.getId(), (String)"\u5bb4\u4f1a\u91c7\u96c6\u52a8\u6001\u6a21\u677fid\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BanquetTemplateVo item = (BanquetTemplateVo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)dynamicForm)), BanquetTemplateVo.class));
        BanquetTemplate banquetTemplate = (BanquetTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, BanquetTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        this.banquetTemplateService.update(banquetTemplate);
    }

    public BanquetTemplateVo findByParentCode(String dynamicKey, String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        BanquetTemplate result = this.banquetTemplateRepository.findByParentCodeAndTenantCode(parentCode, TenantUtils.getTenantCode());
        if (result == null) {
            return null;
        }
        return (BanquetTemplateVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, BanquetTemplateVo.class, HashSet.class, ArrayList.class, new String[0]));
    }
}

