/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.dynamic.template.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.tpm.business.activities.dynamic.template.entity.GeneralTemplate;
import com.biz.crm.tpm.business.activities.dynamic.template.repository.GeneralTemplateRepository;
import com.biz.crm.tpm.business.activities.dynamic.template.service.GeneralTemplateService;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.GeneralTemplateVo;
import com.biz.crm.tpm.business.activities.sdk.register.BudgetCenterModuleRegister;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicFormOperationStrategyForGeneralTemplate
implements DynamicFormOperationStrategy<GeneralTemplateVo> {
    public static final String GENERAL_TEMPLATE_OPERATION_STRATEGY_KEY = StringUtils.uncapitalize((String)DynamicFormOperationStrategyForGeneralTemplate.class.getSimpleName());
    @Autowired
    private BudgetCenterModuleRegister budgetCenterModuleRegister;
    @Autowired
    private GeneralTemplateService generalTemplateService;
    @Autowired
    private GeneralTemplateRepository generalTemplateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormOperationStrategyForGeneralTemplate.class);

    public int getOrder() {
        return 10;
    }

    public String dynamicFormCode() {
        return GENERAL_TEMPLATE_OPERATION_STRATEGY_KEY;
    }

    public String dynamicFormName() {
        return "\u793a\u4f8b\u7528-\u901a\u7528\u91c7\u96c6\u6a21\u677f";
    }

    public Class<GeneralTemplateVo> dynamicFormClass() {
        return GeneralTemplateVo.class;
    }

    public String moduleCode() {
        return this.budgetCenterModuleRegister.moduleCode();
    }

    public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
        this.generalTemplateService.deleteByParentCode(parentCode);
    }

    public void onDynamicFormCreate(GeneralTemplateVo dynamicForm, String dynamicKey, String parentCode, Object parent) {
        Validate.notNull((Object)((Object)dynamicForm), (String)"\u901a\u7528\u91c7\u96c6\u52a8\u6001\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dynamicForm.getId()), (String)"\u901a\u7528\u91c7\u96c6\u52a8\u6001\u6a21\u677fid\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        GeneralTemplateVo item = (GeneralTemplateVo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)dynamicForm)), GeneralTemplateVo.class));
        item.setId(null);
        item.setParentCode(parentCode);
        item.setDynamicKey(dynamicKey);
        item.setDynamicFormCode(GENERAL_TEMPLATE_OPERATION_STRATEGY_KEY);
        GeneralTemplate entity = (GeneralTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, GeneralTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        this.generalTemplateService.create(entity);
    }

    public void onDynamicFormModify(GeneralTemplateVo dynamicForm, String dynamicKey, String parentCode, Object parent) {
        Validate.notNull((Object)((Object)dynamicForm), (String)"\u901a\u7528\u91c7\u96c6\u52a8\u6001\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicForm.getId(), (String)"\u901a\u7528\u91c7\u96c6\u52a8\u6001\u6a21\u677fid\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        GeneralTemplateVo item = (GeneralTemplateVo)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)dynamicForm)), GeneralTemplateVo.class));
        GeneralTemplate generalTemplate = (GeneralTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, GeneralTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        this.generalTemplateService.update(generalTemplate);
    }

    public GeneralTemplateVo findByParentCode(String dynamicKey, String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        GeneralTemplate result = this.generalTemplateRepository.findByParentCodeAndTenantCode(parentCode, TenantUtils.getTenantCode());
        if (result == null) {
            return null;
        }
        return (GeneralTemplateVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, GeneralTemplateVo.class, HashSet.class, ArrayList.class, new String[0]));
    }
}

