/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.dynamic.template.strategy;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.common.form.sdk.context.DynamicFormContext;
import com.biz.crm.common.form.sdk.context.DynamicFormContextHolder;
import com.biz.crm.common.form.sdk.model.DynamicFormsOperationStrategy;
import com.biz.crm.tpm.business.activities.dynamic.template.entity.MaterialActivityItem;
import com.biz.crm.tpm.business.activities.dynamic.template.repository.MaterialActivityItemRepository;
import com.biz.crm.tpm.business.activities.dynamic.template.service.ActivityProductShareInfoService;
import com.biz.crm.tpm.business.activities.dynamic.template.service.MaterialActivityItemService;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.ActivityProductShareInfoVo;
import com.biz.crm.tpm.business.activities.dynamic.template.vo.MaterialActivityItemVo;
import com.biz.crm.tpm.business.activities.sdk.register.ActivitiesCenterModuleRegister;
import com.biz.crm.tpm.business.activities.sdk.strategy.close.ActivityItemsClosedStrategy;
import com.biz.crm.tpm.business.activities.sdk.vo.BaseActivityItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DynamicFormsOperationStrategyForMaterialActivityItem
implements DynamicFormsOperationStrategy<MaterialActivityItemVo>,
ActivityItemsClosedStrategy {
    public static final String MATERIAL_ACTIVITY_ITEM_OPERATION_STRATEGY_KEY = StringUtils.uncapitalize((String)DynamicFormsOperationStrategyForMaterialActivityItem.class.getSimpleName());
    @Autowired
    private ActivitiesCenterModuleRegister activitiesCenterModuleRegister;
    @Autowired
    private MaterialActivityItemService materialActivityItemService;
    @Autowired
    private MaterialActivityItemRepository materialActivityItemRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ActivityProductShareInfoService activityProductShareInfoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormsOperationStrategyForMaterialActivityItem.class);

    public int getOrder() {
        return 9;
    }

    public String dynamicFormCode() {
        return MATERIAL_ACTIVITY_ITEM_OPERATION_STRATEGY_KEY;
    }

    public String dynamicFormName() {
        return "\u793a\u4f8b\u7528-\u7269\u6599\u9886\u7528\u6d3b\u52a8\u6a21\u677f";
    }

    public Class<MaterialActivityItemVo> dynamicFormClass() {
        return MaterialActivityItemVo.class;
    }

    public String moduleCode() {
        return this.activitiesCenterModuleRegister.moduleCode();
    }

    public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
        this.materialActivityItemService.deleteByParentCode(parentCode);
    }

    public void onDynamicFormsCreate(Collection<MaterialActivityItemVo> dynamicForms, String dynamicKey, String parentCode, Object parent) {
        Validate.notEmpty(dynamicForms, (String)"\u7269\u6599\u9886\u7528\u6d3b\u52a8\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List items = JSONArray.parseArray((String)JSONArray.toJSONString(dynamicForms), MaterialActivityItemVo.class);
        this.processDynamicFormContextForFeeDate(items);
        for (MaterialActivityItemVo item : items) {
            item.setParentCode(parentCode);
            item.setDynamicKey(dynamicKey);
            item.setDynamicFormCode(MATERIAL_ACTIVITY_ITEM_OPERATION_STRATEGY_KEY);
            MaterialActivityItem entity = (MaterialActivityItem)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, MaterialActivityItem.class, HashSet.class, ArrayList.class, new String[]{"shareInfos"}));
            this.materialActivityItemService.create(entity);
        }
        long size = items.stream().map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{StringUtils.isNotBlank((CharSequence)e.getOrgCode()) ? e.getOrgCode() : "", StringUtils.isNotBlank((CharSequence)e.getCustomerCode()) ? e.getCustomerCode() : "", StringUtils.isNotBlank((CharSequence)e.getTerminalCode()) ? e.getTerminalCode() : "", StringUtils.isNotBlank((CharSequence)e.getCostBudgetCode()) ? e.getCostBudgetCode() : "", StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode()) ? e.getCostTypeCategoryCode() : "", StringUtils.isNotBlank((CharSequence)e.getCostTypeDetailCode()) ? e.getCostTypeDetailCode() : "", StringUtils.isNotBlank((CharSequence)e.getFeeDate()) ? e.getFeeDate() : ""})).distinct().count();
        Validate.isTrue((size == (long)items.size() ? 1 : 0) != 0, (String)"\u7269\u6599\u9886\u7528\u6d3b\u52a8\u660e\u7ec6\u9879\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    public void onDynamicFormsModify(Collection<MaterialActivityItemVo> dynamicForms, String dynamicKey, String parentCode, Object parent) {
        Validate.notEmpty(dynamicForms, (String)"\u7269\u6599\u9886\u7528\u6d3b\u52a8\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List items = JSONArray.parseArray((String)JSONArray.toJSONString(dynamicForms), MaterialActivityItemVo.class);
        this.processDynamicFormContextForFeeDate(items);
        for (MaterialActivityItemVo item : items) {
            if (!StringUtils.isBlank((CharSequence)item.getId())) continue;
            item.setParentCode(parentCode);
            item.setDynamicKey(dynamicKey);
            item.setDynamicFormCode(MATERIAL_ACTIVITY_ITEM_OPERATION_STRATEGY_KEY);
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)items, MaterialActivityItemVo.class, MaterialActivityItem.class, HashSet.class, ArrayList.class, new String[]{"shareInfos"});
        this.materialActivityItemService.update(collection);
        List<MaterialActivityItem> result = this.materialActivityItemRepository.findByDynamicKeyAndParentCodeAndTenantCode(dynamicKey, parentCode, TenantUtils.getTenantCode());
        long size = result.stream().map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{StringUtils.isNotBlank((CharSequence)e.getOrgCode()) ? e.getOrgCode() : "", StringUtils.isNotBlank((CharSequence)e.getCustomerCode()) ? e.getCustomerCode() : "", StringUtils.isNotBlank((CharSequence)e.getTerminalCode()) ? e.getTerminalCode() : "", StringUtils.isNotBlank((CharSequence)e.getCostBudgetCode()) ? e.getCostBudgetCode() : "", StringUtils.isNotBlank((CharSequence)e.getCostTypeCategoryCode()) ? e.getCostTypeCategoryCode() : "", StringUtils.isNotBlank((CharSequence)e.getCostTypeDetailCode()) ? e.getCostTypeDetailCode() : "", StringUtils.isNotBlank((CharSequence)e.getFeeDate()) ? e.getFeeDate() : ""})).distinct().count();
        Validate.isTrue((size == (long)result.size() ? 1 : 0) != 0, (String)"\u7269\u6599\u9886\u7528\u6d3b\u52a8\u660e\u7ec6\u9879\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    public void onDynamicFormsDelete(String parentCode, String dynamicKey, String[] detailCodes) {
        LOGGER.info("onDynamicFormsDelete(------------)");
    }

    public Collection<MaterialActivityItemVo> findByParentCode(String dynamicKey, String parentCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dynamicKey, parentCode})) {
            return Lists.newArrayList();
        }
        List<MaterialActivityItem> result = this.materialActivityItemRepository.findByDynamicKeyAndParentCodeAndTenantCode(dynamicKey, parentCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(result)) {
            return Lists.newArrayList();
        }
        Collection itemVos = this.nebulaToolkitService.copyCollectionByWhiteList(result, MaterialActivityItem.class, MaterialActivityItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        Set<String> itemIds = itemVos.stream().map(UuidVo::getId).collect(Collectors.toSet());
        List<ActivityProductShareInfoVo> shareInfoVos = this.activityProductShareInfoService.findByAssociateIds(itemIds);
        if (!CollectionUtils.isEmpty(shareInfoVos)) {
            Map<String, List<ActivityProductShareInfoVo>> shareInfoGroups = shareInfoVos.stream().collect(Collectors.groupingBy(ActivityProductShareInfoVo::getAssociateId));
            for (MaterialActivityItemVo itemVo : itemVos) {
                if (!shareInfoGroups.containsKey(itemVo.getId())) continue;
                itemVo.setShareInfos(shareInfoGroups.get(itemVo.getId()));
            }
        }
        return itemVos;
    }

    private void processDynamicFormContextForFeeDate(List<MaterialActivityItemVo> items) {
        String endTimeStr;
        boolean crossMonth;
        DynamicFormContext context = DynamicFormContextHolder.getContext();
        if (!context.exist("startTime") || !context.exist("endTime")) {
            return;
        }
        Date startTime = (Date)context.get("startTime");
        Date endTime = (Date)context.get("endTime");
        String startTimeStr = DateFormatUtils.format((Date)startTime, (String)"yyyy-MM");
        boolean bl = crossMonth = !StringUtils.equals((CharSequence)startTimeStr, (CharSequence)(endTimeStr = DateFormatUtils.format((Date)endTime, (String)"yyyy-MM")));
        if (!crossMonth) {
            items.forEach(e -> e.setFeeDate(startTimeStr));
            return;
        }
        boolean existShare = items.stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)e.getShareKey()));
        if (!existShare) {
            items.forEach(e -> e.setFeeDate(startTimeStr));
            return;
        }
        LinkedList times = Lists.newLinkedList();
        this.dismantle(startTime, endTimeStr, times);
        Set<String> shareKeys = items.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getShareKey())).map(BaseActivityItemVo::getShareKey).collect(Collectors.toSet());
        HashMap shareKeyMaps = Maps.newHashMap();
        shareKeys.forEach(e -> shareKeyMaps.put(e, Lists.newLinkedList((Iterable)times)));
        for (MaterialActivityItemVo itemVo : items) {
            if (StringUtils.isBlank((CharSequence)itemVo.getShareKey())) {
                itemVo.setFeeDate(startTimeStr);
                continue;
            }
            LinkedList theTimes = (LinkedList)shareKeyMaps.get(itemVo.getShareKey());
            Validate.notEmpty((Collection)theTimes, (String)"\u660e\u7ec6\u5206\u644a\u6761\u76ee\u6570\u4e0e\u6d3b\u52a8\u65f6\u95f4\u8303\u56f4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            theTimes.poll();
        }
        shareKeyMaps.values().forEach(e -> Validate.isTrue((e.size() == 0 ? 1 : 0) != 0, (String)"\u5b58\u5728\u6d3b\u52a8\u660e\u7ec6\u5728\u3010%s\u3011\u672a\u5206\u644a\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\u6838\u5bf9", (Object[])new Object[]{StringUtils.join((Iterable)e, (String)",")}));
    }

    private void dismantle(Date startTime, String endTimeStr, List<String> times) {
        String startTimeStr = DateFormatUtils.format((Date)startTime, (String)"yyyy-MM");
        if (StringUtils.compare((String)startTimeStr, (String)endTimeStr) >= 0) {
            times.add(endTimeStr);
            return;
        }
        times.add(DateFormatUtils.format((Date)startTime, (String)"yyyy-MM"));
        this.dismantle(DateUtils.addMonths((Date)startTime, (int)1), endTimeStr, times);
    }

    @Transactional
    public void closed(Set<String> itemCodes) {
        Validate.notEmpty(itemCodes, (String)"\u7269\u6599\u9886\u7528\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialActivityItemRepository.updateForClose(itemCodes);
    }

    public boolean allClosed(String parentCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u4e3b\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MaterialActivityItem> items = this.materialActivityItemRepository.findByParentCodeAndTenantCode(parentCode, TenantUtils.getTenantCode());
        return !CollectionUtils.isEmpty(items) && items.stream().allMatch(e -> e.getColsed() != null && e.getColsed() != false);
    }
}

