package com.biz.crm.tpm.business.activity.apply.rules.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.*;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.service.ActivityApplyRulesService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesFormulaVariableVo;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesPromotionPlanAmountVo;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/10 15:59
 * @description: 活动申请规则表(ActivityApplyRules)表相关的http接口
 */
@RestController
@RequestMapping("/v1/activityApplyRules")
@Slf4j
@Api(tags = "活动申请规则")
public class ActivityApplyRulesController {

    @Autowired
    private ActivityApplyRulesService activityApplyRulesService;


    /**
     * 分页查询所有数据
     *
     * @param pageable              分页对象
     * @param activityApplyRulesDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<ActivityApplyRulesVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "activityApplyRulesDto", value = "活动申请规则主表Dto") ActivityApplyRulesDto activityApplyRulesDto) {
        try {
            Page<ActivityApplyRulesVo> page = this.activityApplyRulesService.findByConditions(pageable, activityApplyRulesDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<ActivityApplyRulesVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            ActivityApplyRulesVo activityApplyRulesVo = this.activityApplyRulesService.findById(id);
            return Result.ok(activityApplyRulesVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param activityApplyRulesDto dto对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "activityApplyRulesDto", value = "活动申请规则主表Dto") @RequestBody ActivityApplyRulesDto activityApplyRulesDto) {
        try {
            this.activityApplyRulesService.create(activityApplyRulesDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param activityApplyRulesDto dto对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "activityApplyRulesDto", value = "活动申请规则主表Dto") @RequestBody ActivityApplyRulesDto activityApplyRulesDto) {
        try {
            this.activityApplyRulesService.update(activityApplyRulesDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping("/delete")
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.activityApplyRulesService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids 主键列表
     * @return 启用结果
     */
    @ApiOperation(value = "启用", httpMethod = "PATCH")
    @PatchMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.activityApplyRulesService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     * @return 禁用结果
     */
    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PatchMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.activityApplyRulesService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取申请规则公式变量
     *
     * @return 列表数据
     */
    @ApiOperation(value = "获取申请规则公式变量")
    @GetMapping("getFormulaVariable")
    public Result<List<ActivityApplyRulesFormulaVariableVo>> getFormulaVariable() {
        try {
            List<ActivityApplyRulesFormulaVariableVo> list = this.activityApplyRulesService.getFormulaVariable();
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 当月销售计算规则金额
     *
     * @param dto 规则匹配参数
     * @return 结果map
     */
    @ApiOperation(value = "当月销售计算规则金额")
    @PostMapping("calAmountMonthSale")
    public Result<ActivityApplyRulesPromotionPlanAmountVo> calAmountMonthSale(@RequestBody MonthSalePromotionPlanAmountDto dto) {
        try {
            ActivityApplyRulesPromotionPlanAmountVo amountVo = this.activityApplyRulesService.calAmountMonthSale(dto);
            return Result.ok(amountVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 当月送货计算规则金额
     *
     * @param dto 规则匹配参数
     * @return 结果map
     */
    @ApiOperation(value = "当月送货计算规则金额")
    @PostMapping("calAmountMonthDelivery")
    public Result<ActivityApplyRulesPromotionPlanAmountVo> calAmountMonthDelivery(@RequestBody MonthDeliveryPromotionPlanAmountDto dto) {
        try {
            ActivityApplyRulesPromotionPlanAmountVo amountVo = this.activityApplyRulesService.calAmountMonthDelivery(dto);
            return Result.ok(amountVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 采销库存费用计算规则金额
     *
     * @param dto 规则匹配参数
     * @return 结果map
     */
    @ApiOperation(value = "采销库存费用计算规则金额")
    @PostMapping("calAmountPurchaseSale")
    public Result<ActivityApplyRulesPromotionPlanAmountVo> calAmountPurchaseSale(@RequestBody PurchaseSalePromotionPlanAmountDto dto) {
        try {
            ActivityApplyRulesPromotionPlanAmountVo amountVo = this.activityApplyRulesService.calAmountPurchaseSale(dto);
            return Result.ok(amountVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 采销库存费用重新计算
     *
     * @param dto 规则匹配参数
     * @return 结果map
     */
    @ApiOperation(value = "采销库存费用重新计算")
    @PostMapping("reCalPurchaseSale")
    public Result<?> reCalPurchaseSale(@RequestBody PurchaseSaleReCalDto dto) {
        try {
            this.activityApplyRulesService.reCalPurchaseSale(dto);
            return Result.ok("重新计算成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
