package com.biz.crm.tpm.business.activity.apply.rules.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author chenlong
 * @date 2022/11/10 15:28
 * @description 活动申请规则表
 */
@ApiModel(value = "ActivityApplyRules", description = "活动申请规则")
@TableName("tpm_activity_apply_rules")
@Getter
@Setter
@Entity(name = "tpm_activity_apply_rules")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_apply_rules", comment = "活动申请规则")
@Table(name = "tpm_activity_apply_rules", indexes = {
        @Index(name = "tpm_apply_rules_index1", columnList = "apply_rules_code", unique = true),
        @Index(name = "tpm_apply_rules_index2", columnList = "activity_form_code,sales_org_code", unique = false),
        @Index(name = "tpm_apply_rules_index3", columnList = "platform_code", unique = false),
        @Index(name = "tpm_apply_rules_index4", columnList = "customer_code", unique = false),
        @Index(name = "tpm_apply_rules_index5", columnList = "estore_channel", unique = false),
})
public class ActivityApplyRules extends TenantFlagOpEntity {

    @ApiModelProperty(name = "申请规则名称", notes = "申请规则名称")
    @Column(name = "apply_rules_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '申请规则名称'")
    private String applyRulesName;

    @ApiModelProperty(name = "申请规则编码", notes = "申请规则编码")
    @Column(name = "apply_rules_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '申请规则编码'")
    private String applyRulesCode;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "销售部门编码", notes = "销售部门编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售部门名称", notes = "销售部门名称")
    @Column(name = "sales_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售部门名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "平台编码", notes = "平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '平台编码'")
    private String platformCode;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "电商渠道编码", notes = "电商渠道编码")
    @Column(name = "estore_channel", length = 32, columnDefinition = "VARCHAR(32) COMMENT '电商渠道编码'")
    private String estoreChannel;

    @ApiModelProperty(name = "电商渠道名称", notes = "电商渠道名称")
    @Column(name = "estore_channel_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '电商渠道名称'")
    private String estoreChannelName;

    @ApiModelProperty("申请金额计算公式")
    @Column(name = "amount_formula", length = 255, columnDefinition = "VARCHAR(255) COMMENT '扣费公式'")
    private String amountFormula;

    @ApiModelProperty("申请金额计算公式（展示用）")
    @Column(name = "amount_formula_name",length = 255, columnDefinition = "VARCHAR(255) COMMENT '扣费公式（展示用）'")
    private String amountFormulaName;

    @ApiModelProperty("申请金额计算公式（json串）")
    @Column(name = "amount_formula_json",length = 500, columnDefinition = "VARCHAR(500) COMMENT '申请金额计算公式（json串）'")
    private String amountFormulaJson;

    @ApiModelProperty("onlyKey")
    @Column(name = "only_key",length = 256, columnDefinition = "VARCHAR(256) COMMENT 'onlyKey'")
    private String onlyKey;
}
