package com.biz.crm.tpm.business.activity.apply.rules.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.apply.rules.local.entity.ActivityApplyRules;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.ActivityApplyRulesDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.ActivityApplyRulesPromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.MonthSalePromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/10 16:01
 * @description: 活动申请规则表(ActivityApplyRules)表mybatis访问层
 */
public interface ActivityApplyRulesMapper extends BaseMapper<ActivityApplyRules> {

    /**
     * 分页查询所有数据
     *
     * @param page                  分页对象
     * @param activityApplyRulesDto 查询Dto
     * @return 所有数据
     */
    Page<ActivityApplyRulesVo> findByConditions(@Param("page") Page<ActivityApplyRulesVo> page, @Param("activityApplyRulesDto") ActivityApplyRulesDto activityApplyRulesDto);

    /**
     * 数据验重
     *
     * @param activityApplyRulesDto 查询Dto
     * @return Integer
     */
    Integer checkDuplicate(@Param("dto") ActivityApplyRulesDto activityApplyRulesDto);

    /**
     * 获取促销规划的申请规则(活动形式+组织+平台+客户)
     *
     * @param dto       查询Dto
     * @param formCodes 活动形式编码列表
     * @return List<ActivityApplyRules>
     */
    List<ActivityApplyRules> getPromotionPlanApplyRulesAll(@Param("dto") ActivityApplyRulesPromotionPlanAmountDto dto, @Param("formCodes") List<String> formCodes);

    /**
     * 获取促销规划的申请规则(活动形式+组织+平台+客户)
     *
     * @param dto       查询Dto
     * @param formCodes 活动形式编码列表
     * @return List<ActivityApplyRules>
     */
    List<ActivityApplyRules> getPromotionPlanNoChannelApplyRules(@Param("dto") ActivityApplyRulesPromotionPlanAmountDto dto, @Param("formCodes") List<String> formCodes);

    /**
     * 获取促销规划的申请规则(活动形式+组织+平台)
     *
     * @param dto       查询Dto
     * @param formCodes 活动形式编码列表
     * @return List<ActivityApplyRules>
     */
    List<ActivityApplyRules> getPromotionPlanNoCusChannelApplyRules(@Param("dto") ActivityApplyRulesPromotionPlanAmountDto dto, @Param("formCodes") List<String> formCodes);

    /**
     * 获取促销规划的申请规则(活动形式+组织)
     *
     * @param dto       查询Dto
     * @param formCodes 活动形式编码列表
     * @return List<ActivityApplyRules>
     */
    List<ActivityApplyRules> getPromotionPlanNoCusPlatformChannelApplyRules(@Param("dto") ActivityApplyRulesPromotionPlanAmountDto dto, @Param("formCodes") List<String> formCodes);
}
