package com.biz.crm.tpm.business.activity.apply.rules.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/11/8 16:57
 * @description: 活动合同数据视图
 */
@Component
@Slf4j
public class ActivityApplyRulesDataviewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_activity_apply_rules_data_view";
    }

    @Override
    public String desc() {
        return "TPM-活动申请规则管理";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_activity_apply_rules t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
