package com.biz.crm.tpm.business.activity.apply.rules.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.apply.rules.local.entity.ActivityApplyRules;
import com.biz.crm.tpm.business.activity.apply.rules.local.mapper.ActivityApplyRulesMapper;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.ActivityApplyRulesDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.ActivityApplyRulesPromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/10 16:02
 * @description: 活动申请规则表(ActivityApplyRules)表数据库访问层
 */
@Component
public class ActivityApplyRulesRepository extends ServiceImpl<ActivityApplyRulesMapper, ActivityApplyRules> {

    @Autowired(required = false)
    private ActivityApplyRulesMapper activityApplyRulesMapper;

    /**
     * 分页查询数据
     *
     * @param pageable              分页对象
     * @param activityApplyRulesDto 查询Dto
     * @return Page<ActivityApplyRulesVo>
     */
    public Page<ActivityApplyRulesVo> findByConditions(Pageable pageable, ActivityApplyRulesDto activityApplyRulesDto) {
        Page<ActivityApplyRulesVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.activityApplyRulesMapper.findByConditions(page, activityApplyRulesDto);
    }

    /**
     * 数据验重
     *
     * @param activityApplyRulesDto 查询Dto
     * @return Integer
     */
    public Integer checkDuplicate(ActivityApplyRulesDto activityApplyRulesDto) {
        return this.activityApplyRulesMapper.checkDuplicate(activityApplyRulesDto);
    }

    /**
     * 获取促销规划的申请规则(活动形式+组织+平台+客户)
     *
     * @param dto       查询Dto
     * @param formCodes 活动形式编码列表
     * @return List<ActivityApplyRules>
     */
    public List<ActivityApplyRules> getPromotionPlanApplyRulesAll(ActivityApplyRulesPromotionPlanAmountDto dto, List<String> formCodes) {
        return this.activityApplyRulesMapper.getPromotionPlanApplyRulesAll(dto, formCodes);
    }

    /**
     * 获取促销规划的申请规则(活动形式+组织+平台+客户)
     *
     * @param dto       查询Dto
     * @param formCodes 活动形式编码列表
     * @return List<ActivityApplyRules>
     */
    public List<ActivityApplyRules> getPromotionPlanNoChannelApplyRules(ActivityApplyRulesPromotionPlanAmountDto dto, List<String> formCodes) {
        return this.activityApplyRulesMapper.getPromotionPlanNoChannelApplyRules(dto, formCodes);
    }

    /**
     * 获取促销规划的申请规则(活动形式+组织+平台)
     *
     * @param dto       查询Dto
     * @param formCodes 活动形式编码列表
     * @return List<ActivityApplyRules>
     */
    public List<ActivityApplyRules> getPromotionPlanNoCusChannelApplyRules(ActivityApplyRulesPromotionPlanAmountDto dto, List<String> formCodes) {
        return this.activityApplyRulesMapper.getPromotionPlanNoCusChannelApplyRules(dto, formCodes);
    }

    /**
     * 获取促销规划的申请规则(活动形式+组织)
     *
     * @param dto       查询Dto
     * @param formCodes 活动形式编码列表
     * @return List<ActivityApplyRules>
     */
    public List<ActivityApplyRules> getPromotionPlanNoCusPlatformChannelApplyRules(ActivityApplyRulesPromotionPlanAmountDto dto, List<String> formCodes) {
        return this.activityApplyRulesMapper.getPromotionPlanNoCusPlatformChannelApplyRules(dto, formCodes);
    }

    /**
     * 逻辑删除
     *
     * @param idList
     */
    public void deleteByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        this.lambdaUpdate()
                .set(ActivityApplyRules::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .eq(ActivityApplyRules::getTenantCode, TenantUtils.getTenantCode())
                .in(ActivityApplyRules::getId,idList)
                .update();

    }
}
