package com.biz.crm.tpm.business.activity.apply.rules.local.service.internal;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.MathUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.service.VariableService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.utils.ActivityApplyRulesVariableUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/12/26 14:26
 * @description: 公式服务实现类
 */
@Slf4j
@Service("variableService")
public class VariableServiceImpl implements VariableService {

    @Autowired(required = false)
    private List<FormulaVariableRegister> formulaVariableRegisterList;
    @Autowired(required = false)
    private ActivityApplyRulesVariableUtil activityApplyRulesVariableUtil;


    @Override
    public BigDecimal singleCalculateExpression(CalculateDto dto) {
        Validate.notNull(dto, "计算公式时，参数不能为空");
        //匹配的公式
        Validate.notNull(dto.getFormula(), "未查找到公式");
        Set<String> formulas = MathUtil.getFormulaReplace(dto.getFormula());
        //获取变量值
        Map<String, BigDecimal> variableValueMap = Maps.newHashMap();
        formulas.forEach(variableName -> {
            List<FormulaVariableRegister> list = formulaVariableRegisterList.stream().filter(register -> variableName.equals(register.getVariableCode())).collect(Collectors.toList());
            Validate.noNullElements(list, "变量注册器不存在");
            FormulaVariableRegister formulaVariableRegister = list.get(0);
            BigDecimal b = formulaVariableRegister.calculateVariable(dto);
            if(Objects.isNull(b)){
                b = BigDecimal.ZERO;
            }
            variableValueMap.put(variableName, b);
        });
        //计算表达式
        //替换
        String expressValue = activityApplyRulesVariableUtil.replaceExpression(dto.getFormula(), formulas, variableValueMap);
        //执行计算
        return MathUtil.computeFormula(expressValue);
    }

    public static void main(String[] args) {
        String str = "(((2000*44)-22745.10)*0.11)-(((7000*44.00)-79644.44)*0.11)";
        System.out.println(MathUtil.computeFormula(str));
    }
}
