package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: 组合数量 变量注册器
 */
@Service
@Slf4j
public class CombinationQuantityVariableRegister implements FormulaVariableRegister {

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "ZHSL";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "组合数量";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 6;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
//        Validate.notNull(calculateDto.getCombinationQuantity(), "组合数量不能为空");
        return calculateDto.getCombinationQuantity();
    }
}
