package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @author: qiancheng
 * @date: 2023/01/15
 * @description: 成本价（元）变量注册器
 */
@Service
public class CostPriceRegister implements FormulaVariableRegister {
    @Override
    public String getVariableCode() {
        return "CBJ";
    }

    @Override
    public String getVariableName() {
        return "成本价（元）";
    }

    @Override
    public Integer getSort() {
        return 24;
    }

    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        return calculateDto.getCostPrice();
    }
}
