package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.CalculateDtoUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/9/22 16:48
 */
@Service
@Slf4j
public class DiscountCouponVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    CalculateDtoUtil calculateDtoUtil;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "YHQFT";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "优惠券分摊";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 27;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        calculateDtoUtil.calDiscountCouponApplicationFee(calculateDto);
        calculateDtoUtil.discountBeforeRatio(calculateDto);
        return calculateDto.getDiscountCouponApplicationFee()
                .multiply(calculateDto.getDiscountBeforeRatio()).setScale(2, BigDecimal.ROUND_HALF_UP);
    }
}
