package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.CalculateDtoUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @author: qiancheng
 * @date: 2023/01/15
 * @description: 双计费用率变量注册器
 */
@Service
@Slf4j
public class DoubleCountCostRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    CalculateDtoUtil calculateDtoUtil;

    @Override
    public String getVariableCode() {
        return "SJFYL";
    }

    @Override
    public String getVariableName() {
        return "双计费用率";
    }

    @Override
    public Integer getSort() {
        return 23;
    }

    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        calculateDtoUtil.calDoubleCountApplicationFee(calculateDto);
//        calculateDtoUtil.calPutInFee(calculateDto);
        calculateDtoUtil.calCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(calculateDto);
        if (calculateDto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return calculateDto.getDoubleCountApplicationFee().divide(calculateDto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(), 10, BigDecimal.ROUND_HALF_UP);
    }
}
