package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: GMV汇总（元） 变量注册器
 */
@Service
@Slf4j
public class GMVVariableRegister implements FormulaVariableRegister {

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "GMVHZ";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "GMV汇总（元）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 25;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        if (CollectionUtils.isEmpty(calculateDto.getMonthSaleServiceCacheList())) {
            return BigDecimal.ZERO;
        }
        BigDecimal b = BigDecimal.ZERO;
        for (CurrentMonthSaleDto dto : calculateDto.getMonthSaleServiceCacheList()) {
            if (Objects.isNull(dto.getGmv())) {
                continue;
            }
            b = b.add(dto.getGmv());
        }
        return b;
    }
}
