package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.CalculateDtoUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author: qiancheng
 * @date: 2023/01/15
 * @description: 当月猫卡变量注册器
 */
@Service
@Slf4j
public class MonthCatCardRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    CalculateDtoUtil calculateDtoUtil;

    @Override
    public String getVariableCode() {
        return "BYMK";
    }

    @Override
    public String getVariableName() {
        return "当月猫卡";
    }

    @Override
    public Integer getSort() {
        return 19;
    }

    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        //{费用申请中活动形式为猫超卡的申请金额*【（当月库存数量*当月库存预估售价）汇总】/当月销售中的GMV汇总}*{（当月库存数量*标准零售价）/【（当月库存数量*标准零售价）汇总】}
        //本月库存数量（箱）
        if (Objects.isNull(calculateDto.getMonthInventoryEnd())) {
            return BigDecimal.ZERO;
        }
        //标准零售价
        if (Objects.isNull(calculateDto.getStandardRetailPrice())) {
            return BigDecimal.ZERO;
        }
        //费用申请中活动形式为猫超卡的申请金额之和
        calculateDtoUtil.calCatCardApplicationFee(calculateDto);
        if (calculateDto.getCatCardApplicationFee().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        //（当月库存数量*当月库存预估售价）汇总
        calculateDtoUtil.calMonthInventoryTotal(calculateDto);
        if (calculateDto.getMonthInventoryTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        //当月销售中的GMV汇总
        calculateDtoUtil.calMonthSaleGmvTotal(calculateDto);
        if (calculateDto.getMonthSaleGmvTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        //【（当月库存数量*标准零售价）汇总】
        calculateDtoUtil.calMonthInventoryStandTotal(calculateDto);
        if (calculateDto.getMonthInventoryStandTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }

        return calculateDto.getCatCardApplicationFee()
                .multiply(calculateDto.getMonthInventoryTotal())
                .multiply(calculateDto.getMonthInventoryEnd())
                .multiply(calculateDto.getStandardRetailPrice())
                .divide(calculateDto.getMonthSaleGmvTotal().multiply(calculateDto.getMonthInventoryStandTotal()), 2, BigDecimal.ROUND_HALF_UP);
    }
}
