package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: 本月期末库存（箱）变量注册器
 */
@Service
@Slf4j
public class MonthInventoryEndVariableRegister implements FormulaVariableRegister {

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "BYQMCC";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "本月期末库存（箱）";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 15;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
//        Validate.notNull(calculateDto.getMonthInventoryEnd(), "本月期末库存（箱）不能为空");
        return calculateDto.getMonthInventoryEnd();
    }
}
