package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.CalculateDtoUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author: qiancheng
 * @date: 2023/01/15
 * @description: 次月猫卡变量注册器
 */
@Service
@Slf4j
public class NextMonthCatCardRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    CalculateDtoUtil calculateDtoUtil;

    @Override
    public String getVariableCode() {
        return "CYMK";
    }

    @Override
    public String getVariableName() {
        return "次月猫卡";
    }

    @Override
    public Integer getSort() {
        return 20;
    }

    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        //{费用申请中活动形式为猫超卡的申请金额*【（次月库存数量*次月库存预估售价）汇总】/当月销售中的GMV汇总}*{（次月库存数量*标准零售价）/【（次月库存数量*标准零售价）汇总】}
        if (Objects.isNull(calculateDto.getNextMonthEndInventory())) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(calculateDto.getStandardRetailPrice())) {
            return BigDecimal.ZERO;
        }
        //费用申请中活动形式为猫超卡的申请金额之和
        calculateDtoUtil.calCatCardApplicationFee(calculateDto);
        if (calculateDto.getCatCardApplicationFee().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        //【（次月库存数量*次月库存预估售价）汇总】
        calculateDtoUtil.calNextMonthInventoryTotal(calculateDto);
        if (calculateDto.getNextMonthInventoryTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        //当月销售中的GMV汇总
        calculateDtoUtil.calMonthSaleGmvTotal(calculateDto);
        if (calculateDto.getMonthSaleGmvTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        //【（次月库存数量*标准零售价）汇总】
        calculateDtoUtil.calNextMonthInventoryStandTotal(calculateDto);
        if (calculateDto.getNextMonthInventoryStandTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }

        return calculateDto.getCatCardApplicationFee()
                .multiply(calculateDto.getNextMonthInventoryTotal())
                .multiply(calculateDto.getNextMonthEndInventory())
                .multiply(calculateDto.getStandardRetailPrice())
                .divide(calculateDto.getMonthSaleGmvTotal().multiply(calculateDto.getNextMonthInventoryStandTotal()), 2, BigDecimal.ROUND_HALF_UP);
    }
}
