package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.CalculateDtoUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author: qiancheng
 * @date: 2023/01/15
 * @description: 次月优惠劵变量注册器
 */
@Service
@Slf4j
public class NextMonthCouponRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    CalculateDtoUtil calculateDtoUtil;

    @Override
    public String getVariableCode() {
        return "CYYHJ";
    }

    @Override
    public String getVariableName() {
        return "次月优惠劵";
    }

    @Override
    public Integer getSort() {
        return 22;
    }

    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        if (Objects.isNull(calculateDto.getNextMonthEndInventory())) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(calculateDto.getNextMonthInventoryAmount())) {
            return BigDecimal.ZERO;
        }
        calculateDtoUtil.calDiscountCouponApplicationFee(calculateDto);
        calculateDtoUtil.calCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(calculateDto);
        if (calculateDto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return calculateDto.getNextMonthEndInventory().multiply(calculateDto.getNextMonthInventoryAmount()).multiply(calculateDto.getDiscountCouponApplicationFee())
                .divide(calculateDto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(), 2, BigDecimal.ROUND_HALF_UP);
    }
}
