package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.CalculateDtoUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author: chenlong
 * @date: 2022/12/21 10:54
 * @description: 投放费用率变量注册器
 */
@Service
@Slf4j
public class PutCostVariableRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    CalculateDtoUtil calculateDtoUtil;

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "TFFYL";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "投放费用率";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 16;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto, "输入参数不能为空");
        //促销规划中：费用申请页面的活动形式排除 ‘费用池-投放’的其他活动形式对应的一级预算项目为投放费用的明细行的申请金额合计/当月销售中的所有行的活动底价*组合系数*预计销量
        calculateDtoUtil.calPutInFee(calculateDto);
        calculateDtoUtil.calCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(calculateDto);
        if (calculateDto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return calculateDto.getPutInFee()
                .divide(calculateDto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(), 10, BigDecimal.ROUND_HALF_UP);
    }
}
