/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.apply.rules.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.activity.apply.rules.local.entity.ActivityApplyRules;
import com.biz.crm.tpm.business.activity.apply.rules.local.repository.ActivityApplyRulesRepository;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.ActivityApplyRulesDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.ActivityApplyRulesPromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.MonthDeliveryPromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.MonthSalePromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.PurchaseSalePromotionPlanAmountDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.PurchaseSaleReCalDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.log.ActivityApplyRulesLogEventDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.enums.PromotionPlanActFormEnum;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.event.log.ActivityApplyRulesEventListener;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.service.ActivityApplyRulesService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.service.VariableService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesFormulaVariableVo;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesPromotionPlanAmountVo;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthDeliveryService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.CurrentMonthSaleService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PurchaseSaleService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityApplyRulesService")
public class ActivityApplyRulesServiceImpl
implements ActivityApplyRulesService {
    private static final Logger log = LoggerFactory.getLogger(ActivityApplyRulesServiceImpl.class);
    @Autowired(required=false)
    private ActivityApplyRulesRepository activityApplyRulesRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private List<FormulaVariableRegister> formulaVariableRegisterList;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private VariableService variableService;
    @Autowired(required=false)
    private CurrentMonthSaleService currentMonthSaleService;
    @Autowired(required=false)
    private CurrentMonthDeliveryService currentMonthDeliveryService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private PurchaseSaleService purchaseSaleService;
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<ActivityApplyRulesVo> findByConditions(Pageable pageable, ActivityApplyRulesDto activityApplyRulesDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(activityApplyRulesDto)) {
            activityApplyRulesDto = new ActivityApplyRulesDto();
        }
        return this.activityApplyRulesRepository.findByConditions(pageable, activityApplyRulesDto);
    }

    public ActivityApplyRulesVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivityApplyRules applyRules = (ActivityApplyRules)((Object)this.activityApplyRulesRepository.getById((Serializable)((Object)id)));
        if (null == applyRules) {
            return null;
        }
        return (ActivityApplyRulesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)applyRules, ActivityApplyRulesVo.class, null, null, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(ActivityApplyRulesDto activityApplyRulesDto) {
        this.createValidate(activityApplyRulesDto);
        activityApplyRulesDto.setCreateAccount(this.loginUserService.getLoginAccountName());
        int count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityApplyRulesRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ActivityApplyRules::getOnlyKey, (Object)activityApplyRulesDto.getOnlyKey())).count();
        ActivityApplyRules applyRules = (ActivityApplyRules)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityApplyRulesDto, ActivityApplyRules.class, null, null, new String[0]));
        String code = (String)this.generateCodeService.generateCode("SQGZ", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        applyRules.setApplyRulesCode(code);
        applyRules.setTenantCode(TenantUtils.getTenantCode());
        applyRules.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        applyRules.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.activityApplyRulesRepository.save((Object)applyRules);
        ActivityApplyRulesLogEventDto logEventDto = new ActivityApplyRulesLogEventDto();
        logEventDto.setOriginal(null);
        activityApplyRulesDto.setId(applyRules.getId());
        logEventDto.setNewest(activityApplyRulesDto);
        SerializableBiConsumer & Serializable onCreate = ActivityApplyRulesEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityApplyRulesEventListener.class, (SerializableBiConsumer)onCreate);
    }

    private void createValidate(ActivityApplyRulesDto activityApplyRulesDto) {
        Validate.notNull((Object)activityApplyRulesDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        activityApplyRulesDto.setId(null);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getApplyRulesName(), (String)"\u65b0\u589e\u65f6\uff0c\u7533\u8bf7\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getActivityFormCode(), (String)"\u65b0\u589e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getActivityFormName(), (String)"\u65b0\u589e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getSalesOrgCode(), (String)"\u65b0\u589e\u65f6\uff0c\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getSalesOrgName(), (String)"\u65b0\u589e\u65f6\uff0c\u9500\u552e\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getAmountFormula(), (String)"\u65b0\u589e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activityApplyRulesDto.getAmountFormulaName(), (String)"\u65b0\u589e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u8ba1\u7b97\u516c\u5f0f\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String onlyKey = activityApplyRulesDto.getActivityFormCode() + activityApplyRulesDto.getSalesOrgCode();
        if (StringUtils.isNotBlank((CharSequence)activityApplyRulesDto.getPlatformCode())) {
            onlyKey = onlyKey + activityApplyRulesDto.getPlatformCode();
        }
        if (StringUtils.isNotBlank((CharSequence)activityApplyRulesDto.getCustomerCode())) {
            onlyKey = onlyKey + activityApplyRulesDto.getCustomerCode();
        }
        activityApplyRulesDto.setOnlyKey(onlyKey);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ActivityApplyRulesDto dto) {
        this.updateValidate(dto);
        int count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityApplyRulesRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ActivityApplyRules::getOnlyKey, (Object)dto.getOnlyKey())).ne(UuidEntity::getId, (Object)dto.getId())).count();
        Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u7533\u8bf7\u89c4\u5219\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", (Object[])new Object[0]);
        ActivityApplyRulesVo oldVo = this.findById(dto.getId());
        dto.setModifyAccount(this.loginUserService.getLoginAccountName());
        ActivityApplyRules applyRules = (ActivityApplyRules)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ActivityApplyRules.class, null, null, new String[0]));
        this.activityApplyRulesRepository.updateById((Object)applyRules);
        ActivityApplyRulesLogEventDto logEventDto = new ActivityApplyRulesLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = ActivityApplyRulesEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityApplyRulesEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    private void updateValidate(ActivityApplyRulesDto activityApplyRulesDto) {
        Validate.notNull((Object)activityApplyRulesDto, (String)"\u7f16\u8f91\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getId(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getApplyRulesName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getActivityFormCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getActivityFormName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getSalesOrgCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getSalesOrgName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u9500\u552e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getAmountFormula(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activityApplyRulesDto.getAmountFormulaName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u8ba1\u7b97\u516c\u5f0f\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityApplyRulesDto.getAmountFormula(), (String)"\u65b0\u589e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activityApplyRulesDto.getAmountFormulaName(), (String)"\u65b0\u589e\u65f6\uff0c\u7533\u8bf7\u91d1\u989d\u8ba1\u7b97\u516c\u5f0f\uff08\u5c55\u793a\u7528\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String onlyKey = activityApplyRulesDto.getActivityFormCode() + activityApplyRulesDto.getSalesOrgCode();
        if (StringUtils.isNotBlank((CharSequence)activityApplyRulesDto.getPlatformCode())) {
            onlyKey = onlyKey + activityApplyRulesDto.getPlatformCode();
        }
        if (StringUtils.isNotBlank((CharSequence)activityApplyRulesDto.getCustomerCode())) {
            onlyKey = onlyKey + activityApplyRulesDto.getCustomerCode();
        }
        activityApplyRulesDto.setOnlyKey(onlyKey);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List rulesList = this.activityApplyRulesRepository.listByIds(idList);
        Validate.notEmpty((Collection)rulesList, (String)"\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        rulesList.forEach(item -> {
            ActivityApplyRulesLogEventDto logEventDto = new ActivityApplyRulesLogEventDto();
            ActivityApplyRulesVo oldVo = (ActivityApplyRulesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, ActivityApplyRulesVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            ActivityApplyRulesDto newDto = (ActivityApplyRulesDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, ActivityApplyRulesDto.class, null, null, new String[0]);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDelete = ActivityApplyRulesEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityApplyRulesEventListener.class, (SerializableBiConsumer)onDelete);
        });
        List<String> ids = rulesList.stream().map(UuidEntity::getId).filter(Objects::nonNull).collect(Collectors.toList());
        this.activityApplyRulesRepository.deleteByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List activityApplyRuless = this.activityApplyRulesRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityApplyRuless) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        ArrayList activityApplyRuleList = new ArrayList();
        activityApplyRuless.forEach(item -> {
            ActivityApplyRules activityApplyRules = new ActivityApplyRules();
            activityApplyRules.setId(item.getId());
            activityApplyRules.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityApplyRuleList.add(activityApplyRules);
            ActivityApplyRulesLogEventDto logEventDto = new ActivityApplyRulesLogEventDto();
            ActivityApplyRulesVo oldVo = (ActivityApplyRulesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, ActivityApplyRulesVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            ActivityApplyRulesDto newDto = (ActivityApplyRulesDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, ActivityApplyRulesDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onEnable = ActivityApplyRulesEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityApplyRulesEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.activityApplyRulesRepository.updateBatchById(activityApplyRuleList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List activityApplyRuless = this.activityApplyRulesRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityApplyRuless) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        ArrayList activityApplyRuleList = new ArrayList();
        activityApplyRuless.forEach(item -> {
            ActivityApplyRules activityApplyRules = new ActivityApplyRules();
            activityApplyRules.setId(item.getId());
            activityApplyRules.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            activityApplyRuleList.add(activityApplyRules);
            ActivityApplyRulesLogEventDto logEventDto = new ActivityApplyRulesLogEventDto();
            ActivityApplyRulesVo oldVo = (ActivityApplyRulesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, ActivityApplyRulesVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            ActivityApplyRulesDto newDto = (ActivityApplyRulesDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, ActivityApplyRulesDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDisable = ActivityApplyRulesEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityApplyRulesEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.activityApplyRulesRepository.updateBatchById(activityApplyRuleList);
    }

    public List<ActivityApplyRulesFormulaVariableVo> getFormulaVariable() {
        ArrayList voList = new ArrayList();
        if (!CollectionUtils.isEmpty(this.formulaVariableRegisterList)) {
            this.formulaVariableRegisterList.forEach(register -> {
                ActivityApplyRulesFormulaVariableVo vo = new ActivityApplyRulesFormulaVariableVo();
                vo.setCode(register.getVariableCode());
                vo.setName(register.getVariableName());
                vo.setSort(register.getSort());
                voList.add(vo);
            });
        }
        if (!CollectionUtils.isEmpty(voList)) {
            return voList.stream().sorted(Comparator.comparing(ActivityApplyRulesFormulaVariableVo::getSort)).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public ActivityApplyRulesPromotionPlanAmountVo calAmountMonthSale(MonthSalePromotionPlanAmountDto dto) {
        this.calMonthSaleValidate(dto);
        Map formMap = this.dictToolkitService.findMapByDictTypeCode("promotion_plan_act_form2");
        if (formMap.isEmpty()) {
            return new ActivityApplyRulesPromotionPlanAmountVo();
        }
        ArrayList<String> formCodes = new ArrayList<String>();
        this.getFormCode(formMap, PromotionPlanActFormEnum.PRODUCT_PROMOTION, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.LARGE_DATE_PROCESS, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.NEW_CUSTOMER, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.OLD_CUSTOMER, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.TIKTOK_MASTER, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.PLATFORM_GROSS_PROTECTION, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.PLATFORM_SERVICE, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.PLATFORM_REBATE, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.PLATFORM_COMMISSION, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.SALE_COMMISSION, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.CHANNEL_PROMOTION_FEE, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.UNEVEN, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.HIGH_TURNOVER, formCodes);
        if (CollectionUtils.isEmpty(formCodes)) {
            return new ActivityApplyRulesPromotionPlanAmountVo();
        }
        ActivityApplyRulesPromotionPlanAmountDto amountDto = new ActivityApplyRulesPromotionPlanAmountDto();
        amountDto.setTenantCode(TenantUtils.getTenantCode());
        amountDto.setSalesOrgCode(dto.getSalesOrgCode());
        amountDto.setPlatformCode(dto.getPlatformCode());
        amountDto.setCustomerCode(dto.getCustomerCode());
        amountDto.setEstoreChannel(dto.getChannelCode());
        Map<String, Map<String, ActivityApplyRules>> applyRulesMap = this.getActivityApplyRuleMap(amountDto, formCodes);
        CalculateDto calculateDto = new CalculateDto();
        calculateDto.setTaxRate(dto.getTaxRate());
        calculateDto.setRatio(dto.getRatio());
        calculateDto.setStandardRetailPrice(dto.getStandardRetailPrice());
        calculateDto.setPlatformSupplyPrice(dto.getPlatformSupplyPrice());
        calculateDto.setActivityBasePrice(dto.getActivityBasePrice());
        calculateDto.setCombinationQuantity(dto.getCombinationQuantity());
        calculateDto.setEstimatedSalesBox(dto.getEstimatedSalesBox());
        calculateDto.setEstimatedSalesTon(dto.getEstimatedSalesTon());
        calculateDto.setVat(dto.getVat());
        calculateDto.setEstimatedAmountBefore(dto.getEstimatedAmountBefore());
        calculateDto.setEstimatedAmountAfter(dto.getEstimatedAmountAfter());
        calculateDto.setCostPrice(dto.getCostPrice());
        calculateDto.setGmv(dto.getGmv());
        calculateDto.setFormMap(formMap);
        if (!CollectionUtils.isEmpty((Collection)dto.getCurrentMonthSaleDtoList())) {
            calculateDto.setMonthSaleServiceCacheList(dto.getCurrentMonthSaleDtoList());
        } else if (StringUtils.isNotBlank((CharSequence)dto.getMonthSaleCacheKey())) {
            List salesList = this.currentMonthSaleService.findCacheList(dto.getMonthSaleCacheKey());
            if (CollectionUtils.isEmpty((Collection)salesList)) {
                if (StringUtils.isNotBlank((CharSequence)dto.getPromotionPlanCode())) {
                    calculateDto.setMonthSaleServiceCacheList(this.currentMonthSaleService.findList(dto.getPromotionPlanCode()));
                }
            } else {
                calculateDto.setMonthSaleServiceCacheList(salesList);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getExpensesDtoList())) {
            calculateDto.setExpensesServiceCacheList(dto.getExpensesDtoList());
        } else if (StringUtils.isNotBlank((CharSequence)dto.getGeneralExpensesCacheKey())) {
            List expensesDtoList = this.generalExpensesService.findCacheList(dto.getGeneralExpensesCacheKey());
            if (CollectionUtils.isEmpty((Collection)expensesDtoList)) {
                if (StringUtils.isNotBlank((CharSequence)dto.getPromotionPlanCode())) {
                    calculateDto.setExpensesServiceCacheList(this.generalExpensesService.findList(dto.getPromotionPlanCode()));
                }
            } else {
                calculateDto.setExpensesServiceCacheList(expensesDtoList);
            }
        }
        ActivityApplyRulesPromotionPlanAmountVo amountVo = new ActivityApplyRulesPromotionPlanAmountVo();
        amountVo.setProductPromotion(this.packageFormValue(formMap, PromotionPlanActFormEnum.PRODUCT_PROMOTION, applyRulesMap, calculateDto));
        amountVo.setLargeDateProcess(this.packageFormValue(formMap, PromotionPlanActFormEnum.LARGE_DATE_PROCESS, applyRulesMap, calculateDto));
        amountVo.setNewCustomer(this.packageFormValue(formMap, PromotionPlanActFormEnum.NEW_CUSTOMER, applyRulesMap, calculateDto));
        amountVo.setOldCustomer(this.packageFormValue(formMap, PromotionPlanActFormEnum.OLD_CUSTOMER, applyRulesMap, calculateDto));
        amountVo.setTiktokMaster(this.packageFormValue(formMap, PromotionPlanActFormEnum.TIKTOK_MASTER, applyRulesMap, calculateDto));
        amountVo.setPlatformGrossProtection(this.packageFormValue(formMap, PromotionPlanActFormEnum.PLATFORM_GROSS_PROTECTION, applyRulesMap, calculateDto));
        amountVo.setPlatformService(this.packageFormValue(formMap, PromotionPlanActFormEnum.PLATFORM_SERVICE, applyRulesMap, calculateDto));
        amountVo.setPlatformRebate(this.packageFormValue(formMap, PromotionPlanActFormEnum.PLATFORM_REBATE, applyRulesMap, calculateDto));
        amountVo.setPlatformCommission(this.packageFormValue(formMap, PromotionPlanActFormEnum.PLATFORM_COMMISSION, applyRulesMap, calculateDto));
        amountVo.setSaleCommission(this.packageFormValue(formMap, PromotionPlanActFormEnum.SALE_COMMISSION, applyRulesMap, calculateDto));
        amountVo.setChannelPromotionFee(this.packageFormValue(formMap, PromotionPlanActFormEnum.CHANNEL_PROMOTION_FEE, applyRulesMap, calculateDto));
        amountVo.setUneven(this.packageFormValue(formMap, PromotionPlanActFormEnum.UNEVEN, applyRulesMap, calculateDto));
        amountVo.setHighTurnover(this.packageFormValue(formMap, PromotionPlanActFormEnum.HIGH_TURNOVER, applyRulesMap, calculateDto));
        return amountVo;
    }

    private Map<String, Map<String, ActivityApplyRules>> getActivityApplyRuleMap(ActivityApplyRulesPromotionPlanAmountDto amountDto, List<String> formCodes) {
        if (CollectionUtil.isEmpty(formCodes)) {
            return Collections.emptyMap();
        }
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        List<ActivityApplyRules> rulesList = this.activityApplyRulesRepository.getPromotionPlanApplyRulesAll(amountDto, formCodes);
        if (CollectionUtil.isNotEmpty(rulesList)) {
            resultMap.put("1", rulesList.stream().collect(Collectors.toMap(ActivityApplyRules::getActivityFormCode, v -> v, (newValue, oldValue) -> newValue)));
        }
        if (CollectionUtil.isNotEmpty(rulesList = this.activityApplyRulesRepository.getPromotionPlanNoChannelApplyRules(amountDto, formCodes))) {
            resultMap.put("2", rulesList.stream().collect(Collectors.toMap(ActivityApplyRules::getActivityFormCode, v -> v, (newValue, oldValue) -> newValue)));
        }
        if (CollectionUtil.isNotEmpty(rulesList = this.activityApplyRulesRepository.getPromotionPlanNoCusChannelApplyRules(amountDto, formCodes))) {
            resultMap.put("3", rulesList.stream().collect(Collectors.toMap(ActivityApplyRules::getActivityFormCode, v -> v, (newValue, oldValue) -> newValue)));
        }
        if (CollectionUtil.isNotEmpty(rulesList = this.activityApplyRulesRepository.getPromotionPlanNoCusPlatformChannelApplyRules(amountDto, formCodes))) {
            resultMap.put("4", rulesList.stream().collect(Collectors.toMap(ActivityApplyRules::getActivityFormCode, v -> v, (newValue, oldValue) -> newValue)));
        }
        resultMap.putIfAbsent("1", Maps.newHashMap());
        resultMap.putIfAbsent("2", Maps.newHashMap());
        resultMap.putIfAbsent("3", Maps.newHashMap());
        resultMap.putIfAbsent("4", Maps.newHashMap());
        return resultMap;
    }

    private void getFormCode(Map<String, String> formMap, PromotionPlanActFormEnum formEnum, List<String> formCodes) {
        String formCode = formMap.getOrDefault(formEnum.getCode(), null);
        if (StringUtils.isNotBlank((CharSequence)formCode)) {
            formCodes.add(formCode);
        }
    }

    private BigDecimal packageFormValue(Map<String, String> formMap, PromotionPlanActFormEnum formEnum, Map<String, Map<String, ActivityApplyRules>> applyRulesMap, CalculateDto calculateDto) {
        String formCode = formMap.getOrDefault(formEnum.getCode(), null);
        if (StringUtils.isBlank((CharSequence)formCode)) {
            return BigDecimal.ZERO;
        }
        ActivityApplyRules rules = this.getActivityApplyRules(applyRulesMap, formCode);
        if (Objects.isNull((Object)rules)) {
            return BigDecimal.ZERO;
        }
        calculateDto.setFormula(rules.getAmountFormula());
        return this.variableService.singleCalculateExpression(calculateDto);
    }

    private ActivityApplyRules getActivityApplyRules(Map<String, Map<String, ActivityApplyRules>> applyRulesMap, String formCode) {
        if (CollectionUtil.isEmpty(applyRulesMap) || StringUtils.isEmpty((CharSequence)formCode)) {
            return null;
        }
        Map<String, ActivityApplyRules> map = applyRulesMap.getOrDefault("1", Maps.newHashMap());
        ActivityApplyRules rules = map.getOrDefault(formCode, null);
        if (Objects.nonNull((Object)rules)) {
            return rules;
        }
        map = applyRulesMap.getOrDefault("2", Maps.newHashMap());
        rules = map.getOrDefault(formCode, null);
        if (Objects.nonNull((Object)rules)) {
            return rules;
        }
        map = applyRulesMap.getOrDefault("3", Maps.newHashMap());
        rules = map.getOrDefault(formCode, null);
        if (Objects.nonNull((Object)rules)) {
            return rules;
        }
        map = applyRulesMap.getOrDefault("4", Maps.newHashMap());
        rules = map.getOrDefault(formCode, null);
        if (Objects.nonNull((Object)rules)) {
            return rules;
        }
        return null;
    }

    public ActivityApplyRulesPromotionPlanAmountVo calAmountMonthDelivery(MonthDeliveryPromotionPlanAmountDto dto) {
        this.calMonthDeliveryValidate(dto);
        Map formMap = this.dictToolkitService.findMapByDictTypeCode("promotion_plan_act_form2");
        Validate.isTrue((!formMap.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u67e5\u627e\u5230\u4fc3\u9500\u89c4\u5212\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u914d\u7f6e\u5b57\u5178", (Object[])new Object[0]);
        ArrayList<String> formCodes = new ArrayList<String>();
        this.getFormCode(formMap, PromotionPlanActFormEnum.CHANNEL_PROMOTION_FEE, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.PURCHASE_REBATE, formCodes);
        ActivityApplyRulesPromotionPlanAmountDto amountDto = new ActivityApplyRulesPromotionPlanAmountDto();
        amountDto.setTenantCode(TenantUtils.getTenantCode());
        amountDto.setSalesOrgCode(dto.getSalesOrgCode());
        amountDto.setCustomerCode(dto.getCustomerCode());
        amountDto.setPlatformCode(dto.getPlatformCode());
        amountDto.setEstoreChannel(dto.getChannelCode());
        Map<String, Map<String, ActivityApplyRules>> applyRulesMap = this.getActivityApplyRuleMap(amountDto, formCodes);
        CalculateDto calculateDto = new CalculateDto();
        calculateDto.setTaxRate(dto.getTaxRate());
        calculateDto.setRatio(dto.getRatio());
        calculateDto.setStandardRetailPrice(dto.getStandardRetailPrice());
        calculateDto.setPlatformSupplyPrice(dto.getPlatformSupplyPrice());
        calculateDto.setActivityBasePrice(dto.getActivityBasePrice());
        calculateDto.setCombinationQuantity(dto.getCombinationQuantity());
        calculateDto.setEstimatedSalesBox(dto.getEstimatedSalesBox());
        calculateDto.setEstimatedSalesTon(dto.getEstimatedSalesTon());
        calculateDto.setVat(dto.getVat());
        calculateDto.setEstimatedAmount(dto.getEstimatedAmount());
        calculateDto.setCostPrice(dto.getCostPrice());
        calculateDto.setFormMap(formMap);
        ActivityApplyRulesPromotionPlanAmountVo amountVo = new ActivityApplyRulesPromotionPlanAmountVo();
        amountVo.setChannelPromotionFee(this.packageFormValue(formMap, PromotionPlanActFormEnum.CHANNEL_PROMOTION_FEE, applyRulesMap, calculateDto));
        amountVo.setPurchaseRebate(this.packageFormValue(formMap, PromotionPlanActFormEnum.PURCHASE_REBATE, applyRulesMap, calculateDto));
        return amountVo;
    }

    public ActivityApplyRulesPromotionPlanAmountVo calAmountPurchaseSale(PurchaseSalePromotionPlanAmountDto dto) {
        this.calPurchaseSaleValidate(dto);
        Map formMap = this.dictToolkitService.findMapByDictTypeCode("promotion_plan_act_form2");
        Validate.isTrue((!formMap.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u67e5\u627e\u5230\u4fc3\u9500\u89c4\u5212\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u914d\u7f6e\u5b57\u5178", (Object[])new Object[0]);
        ArrayList<String> formCodes = new ArrayList<String>();
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_DIFFERENCE, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_SALE_COMMISSION, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_PURCHASE_REBATE, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_PUT, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_GROSS_PROTECTION, formCodes);
        ActivityApplyRulesPromotionPlanAmountDto amountDto = new ActivityApplyRulesPromotionPlanAmountDto();
        amountDto.setTenantCode(TenantUtils.getTenantCode());
        amountDto.setSalesOrgCode(dto.getSalesOrgCode());
        amountDto.setCustomerCode(dto.getCustomerCode());
        amountDto.setPlatformCode(dto.getPlatformCode());
        amountDto.setEstoreChannel(dto.getChannelCode());
        Map<String, Map<String, ActivityApplyRules>> applyRulesMap = this.getActivityApplyRuleMap(amountDto, formCodes);
        CalculateDto calculateDto = new CalculateDto();
        calculateDto.setSupplyPrice(dto.getSupplyPrice());
        calculateDto.setPromotionPrice(dto.getPromotionPrice());
        calculateDto.setMonthInventoryEnd(dto.getMonthInventoryEnd());
        calculateDto.setNextMonthEndInventory(dto.getNextMonthEndInventory());
        calculateDto.setNextMonthInventoryAmount(dto.getNextMonthInventoryAmount());
        calculateDto.setStandardRetailPrice(dto.getStandardRetailPrice());
        calculateDto.setCostPrice(dto.getCostPrice());
        calculateDto.setPurchaseId(dto.getId());
        calculateDto.setFormMap(formMap);
        if (StringUtils.isNotBlank((CharSequence)dto.getMonthSaleCacheKey())) {
            List salesList = this.currentMonthSaleService.findCacheList(dto.getMonthSaleCacheKey());
            if (CollectionUtils.isEmpty((Collection)salesList)) {
                if (StringUtils.isNotBlank((CharSequence)dto.getPromotionPlanCode())) {
                    calculateDto.setMonthSaleServiceCacheList(this.currentMonthSaleService.findList(dto.getPromotionPlanCode()));
                }
            } else {
                calculateDto.setMonthSaleServiceCacheList(salesList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getGeneralExpensesCacheKey())) {
            List expensesDtoList = this.generalExpensesService.findCacheList(dto.getGeneralExpensesCacheKey());
            if (CollectionUtils.isEmpty((Collection)expensesDtoList)) {
                if (StringUtils.isNotBlank((CharSequence)dto.getPromotionPlanCode())) {
                    calculateDto.setExpensesServiceCacheList(this.generalExpensesService.findList(dto.getPromotionPlanCode()));
                }
            } else {
                calculateDto.setExpensesServiceCacheList(expensesDtoList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCacheKey())) {
            List purchaseSaleDtoList = this.purchaseSaleService.findCacheList(dto.getCacheKey());
            if (CollectionUtils.isEmpty((Collection)purchaseSaleDtoList)) {
                if (StringUtils.isNotBlank((CharSequence)dto.getPromotionPlanCode())) {
                    calculateDto.setPurchaseSaleServiceCacheList(this.purchaseSaleService.findList(dto.getPromotionPlanCode()));
                }
            } else {
                calculateDto.setPurchaseSaleServiceCacheList(purchaseSaleDtoList);
            }
        }
        ActivityApplyRulesPromotionPlanAmountVo amountVo = new ActivityApplyRulesPromotionPlanAmountVo();
        amountVo.setFeePoolDifference(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_DIFFERENCE, applyRulesMap, calculateDto));
        amountVo.setFeePoolSaleCommission(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_SALE_COMMISSION, applyRulesMap, calculateDto));
        amountVo.setFeePoolPurchaseRebate(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_PURCHASE_REBATE, applyRulesMap, calculateDto));
        amountVo.setFeePoolPut(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_PUT, applyRulesMap, calculateDto));
        amountVo.setFeePoolGrossProtection(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_GROSS_PROTECTION, applyRulesMap, calculateDto));
        return amountVo;
    }

    public void reCalPurchaseSale(PurchaseSaleReCalDto dto) {
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPlatformCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCacheKey()), (String)"\u91c7\u9500\u5e93\u5b58\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map formMap = this.dictToolkitService.findMapByDictTypeCode("promotion_plan_act_form2");
        Validate.isTrue((!formMap.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u67e5\u627e\u5230\u4fc3\u9500\u89c4\u5212\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u914d\u7f6e\u5b57\u5178", (Object[])new Object[0]);
        ArrayList<String> formCodes = new ArrayList<String>();
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_DIFFERENCE, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_SALE_COMMISSION, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_PURCHASE_REBATE, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_PUT, formCodes);
        this.getFormCode(formMap, PromotionPlanActFormEnum.FEE_POOL_GROSS_PROTECTION, formCodes);
        ActivityApplyRulesPromotionPlanAmountDto amountDto = new ActivityApplyRulesPromotionPlanAmountDto();
        amountDto.setTenantCode(TenantUtils.getTenantCode());
        amountDto.setSalesOrgCode(dto.getSalesOrgCode());
        amountDto.setCustomerCode(dto.getCustomerCode());
        amountDto.setPlatformCode(dto.getPlatformCode());
        amountDto.setEstoreChannel(dto.getChannelCode());
        Map<String, Map<String, ActivityApplyRules>> applyRulesMap = this.getActivityApplyRuleMap(amountDto, formCodes);
        List purchaseSaleDtoList = this.purchaseSaleService.findCacheList(dto.getCacheKey());
        if (CollectionUtils.isEmpty((Collection)purchaseSaleDtoList)) {
            if (StringUtils.isNotBlank((CharSequence)dto.getPromotionPlanCode())) {
                purchaseSaleDtoList = this.purchaseSaleService.findList(dto.getPromotionPlanCode());
            } else {
                return;
            }
        }
        CalculateDto calculateDto = new CalculateDto();
        calculateDto.setFormMap(formMap);
        calculateDto.setPurchaseSaleServiceCacheList(purchaseSaleDtoList);
        if (StringUtils.isNotBlank((CharSequence)dto.getMonthSaleCacheKey())) {
            List salesList = this.currentMonthSaleService.findCacheList(dto.getMonthSaleCacheKey());
            if (CollectionUtils.isEmpty((Collection)salesList)) {
                if (StringUtils.isNotBlank((CharSequence)dto.getPromotionPlanCode())) {
                    calculateDto.setMonthSaleServiceCacheList(this.currentMonthSaleService.findList(dto.getPromotionPlanCode()));
                }
            } else {
                calculateDto.setMonthSaleServiceCacheList(salesList);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getGeneralExpensesCacheKey())) {
            List expensesDtoList = this.generalExpensesService.findCacheList(dto.getGeneralExpensesCacheKey());
            if (CollectionUtils.isEmpty((Collection)expensesDtoList)) {
                if (StringUtils.isNotBlank((CharSequence)dto.getPromotionPlanCode())) {
                    calculateDto.setExpensesServiceCacheList(this.generalExpensesService.findList(dto.getPromotionPlanCode()));
                }
            } else {
                calculateDto.setExpensesServiceCacheList(expensesDtoList);
            }
        }
        for (PurchaseSaleDto saleDto : purchaseSaleDtoList) {
            calculateDto.setSupplyPrice(saleDto.getSupplyPrice());
            calculateDto.setPromotionPrice(saleDto.getPromotionPrice());
            calculateDto.setMonthInventoryEnd(saleDto.getMonthInventoryEnd());
            calculateDto.setNextMonthEndInventory(saleDto.getNextMonthEndInventory());
            calculateDto.setNextMonthInventoryAmount(saleDto.getNextMonthInventoryAmount());
            calculateDto.setStandardRetailPrice(saleDto.getStandardRetailPrice());
            calculateDto.setCostPrice(saleDto.getCostPrice());
            calculateDto.setPurchaseId(saleDto.getId());
            saleDto.setFeePoolDifference(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_DIFFERENCE, applyRulesMap, calculateDto));
            saleDto.setFeePoolSaleCommission(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_SALE_COMMISSION, applyRulesMap, calculateDto));
            saleDto.setFeePoolPurchaseRebate(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_PURCHASE_REBATE, applyRulesMap, calculateDto));
            saleDto.setFeePoolPut(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_PUT, applyRulesMap, calculateDto));
            saleDto.setFeePoolGrossProtection(this.packageFormValue(formMap, PromotionPlanActFormEnum.FEE_POOL_GROSS_PROTECTION, applyRulesMap, calculateDto));
        }
        this.purchaseSaleService.updateListCache(dto.getCacheKey(), purchaseSaleDtoList);
    }

    private void calMonthSaleValidate(MonthSalePromotionPlanAmountDto dto) {
        Validate.notNull((Object)dto, (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPlatformCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartDate(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void calMonthDeliveryValidate(MonthDeliveryPromotionPlanAmountDto dto) {
        Validate.notNull((Object)dto, (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPlatformCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void calPurchaseSaleValidate(PurchaseSalePromotionPlanAmountDto dto) {
        Validate.notNull((Object)dto, (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPlatformCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u8ba1\u7b97\u91d1\u989d\u65f6\uff0c\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

