/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.apply.rules.local.service.internal;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.MathUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.service.VariableService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.utils.ActivityApplyRulesVariableUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="variableService")
public class VariableServiceImpl
implements VariableService {
    private static final Logger log = LoggerFactory.getLogger(VariableServiceImpl.class);
    @Autowired(required=false)
    private List<FormulaVariableRegister> formulaVariableRegisterList;
    @Autowired(required=false)
    private ActivityApplyRulesVariableUtil activityApplyRulesVariableUtil;

    public BigDecimal singleCalculateExpression(CalculateDto dto) {
        Validate.notNull((Object)dto, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getFormula(), (String)"\u672a\u67e5\u627e\u5230\u516c\u5f0f", (Object[])new Object[0]);
        Set<String> formulas = MathUtil.getFormulaReplace(dto.getFormula());
        HashMap variableValueMap = Maps.newHashMap();
        formulas.forEach(variableName -> {
            List list = this.formulaVariableRegisterList.stream().filter(register -> variableName.equals(register.getVariableCode())).collect(Collectors.toList());
            Validate.noNullElements(list, (String)"\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            FormulaVariableRegister formulaVariableRegister = (FormulaVariableRegister)list.get(0);
            BigDecimal b = formulaVariableRegister.calculateVariable(dto);
            if (Objects.isNull(b)) {
                b = BigDecimal.ZERO;
            }
            variableValueMap.put(variableName, b);
        });
        String expressValue = this.activityApplyRulesVariableUtil.replaceExpression(dto.getFormula(), formulas, (Map)variableValueMap);
        return MathUtil.computeFormula(expressValue);
    }

    public static void main(String[] args) {
        String str = "(((2000*44)-22745.10)*0.11)-(((7000*44.00)-79644.44)*0.11)";
        System.out.println(MathUtil.computeFormula(str));
    }
}

