/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.CalculateDtoUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonthCouponRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(MonthCouponRegister.class);
    @Autowired(required=false)
    CalculateDtoUtil calculateDtoUtil;

    public String getVariableCode() {
        return "BYYHJ";
    }

    public String getVariableName() {
        return "\u5f53\u6708\u4f18\u60e0\u5238";
    }

    public Integer getSort() {
        return 21;
    }

    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (Objects.isNull(calculateDto.getMonthInventoryEnd())) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(calculateDto.getPromotionPrice())) {
            return BigDecimal.ZERO;
        }
        this.calculateDtoUtil.calDiscountCouponApplicationFee(calculateDto);
        this.calculateDtoUtil.calCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(calculateDto);
        if (calculateDto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return calculateDto.getMonthInventoryEnd().multiply(calculateDto.getPromotionPrice()).multiply(calculateDto.getDiscountCouponApplicationFee()).divide(calculateDto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(), 2, 4);
    }
}

