/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.apply.rules.local.variable.register;

import com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils.CalculateDtoUtil;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.variable.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NextMonthCatCardRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(NextMonthCatCardRegister.class);
    @Autowired(required=false)
    CalculateDtoUtil calculateDtoUtil;

    public String getVariableCode() {
        return "CYMK";
    }

    public String getVariableName() {
        return "\u6b21\u6708\u732b\u5361";
    }

    public Integer getSort() {
        return 20;
    }

    public BigDecimal calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (Objects.isNull(calculateDto.getNextMonthEndInventory())) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(calculateDto.getStandardRetailPrice())) {
            return BigDecimal.ZERO;
        }
        this.calculateDtoUtil.calCatCardApplicationFee(calculateDto);
        if (calculateDto.getCatCardApplicationFee().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        this.calculateDtoUtil.calNextMonthInventoryTotal(calculateDto);
        if (calculateDto.getNextMonthInventoryTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        this.calculateDtoUtil.calMonthSaleGmvTotal(calculateDto);
        if (calculateDto.getMonthSaleGmvTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        this.calculateDtoUtil.calNextMonthInventoryStandTotal(calculateDto);
        if (calculateDto.getNextMonthInventoryStandTotal().compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return calculateDto.getCatCardApplicationFee().multiply(calculateDto.getNextMonthInventoryTotal()).multiply(calculateDto.getNextMonthEndInventory()).multiply(calculateDto.getStandardRetailPrice()).divide(calculateDto.getMonthSaleGmvTotal().multiply(calculateDto.getNextMonthInventoryStandTotal()), 2, 4);
    }
}

