/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.apply.rules.local.variable.utils;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.enums.PromotionPlanActFormEnum;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.enums.PromotionPlanPutCostEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalculateDtoUtil {
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public void calCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(CalculateDto dto) {
        if (Objects.nonNull(dto.getCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum())) {
            return;
        }
        List monthSaleServiceCacheList = dto.getMonthSaleServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)monthSaleServiceCacheList)) {
            dto.setCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(BigDecimal.ZERO);
            return;
        }
        BigDecimal currentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum = monthSaleServiceCacheList.stream().filter(Objects::nonNull).map(e -> {
            if (Objects.isNull(e.getActivityBasePrice()) || Objects.isNull(e.getCombinationQuantity()) || Objects.isNull(e.getEstimatedSalesBox())) {
                return BigDecimal.ZERO;
            }
            return e.getActivityBasePrice().multiply(e.getCombinationQuantity()).multiply(e.getEstimatedSalesBox());
        }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        dto.setCurrentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum(currentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum);
    }

    public void calCatCardApplicationFee(CalculateDto dto) {
        if (Objects.nonNull(dto.getCatCardApplicationFee())) {
            return;
        }
        List expensesServiceCacheList = dto.getExpensesServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)expensesServiceCacheList)) {
            dto.setCatCardApplicationFee(BigDecimal.ZERO);
            return;
        }
        String fromCode = dto.getFormMap().getOrDefault(PromotionPlanActFormEnum.CAT_CARD.getCode(), null);
        if (StringUtils.isBlank((CharSequence)fromCode)) {
            dto.setCatCardApplicationFee(BigDecimal.ZERO);
            return;
        }
        BigDecimal catCardApplicationFee = expensesServiceCacheList.stream().filter(e -> fromCode.equals(e.getActivityFormCode())).map(GeneralExpensesDto::getApplyAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        dto.setCatCardApplicationFee(catCardApplicationFee);
    }

    public void calDiscountCouponApplicationFee(CalculateDto dto) {
        if (Objects.nonNull(dto.getDiscountCouponApplicationFee())) {
            return;
        }
        List expensesServiceCacheList = dto.getExpensesServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)expensesServiceCacheList)) {
            dto.setDiscountCouponApplicationFee(BigDecimal.ZERO);
            return;
        }
        String fromCode = dto.getFormMap().getOrDefault(PromotionPlanActFormEnum.DISCOUNT_COUPON.getCode(), null);
        if (StringUtils.isBlank((CharSequence)fromCode)) {
            dto.setDiscountCouponApplicationFee(BigDecimal.ZERO);
            return;
        }
        BigDecimal discountCouponApplicationFee = expensesServiceCacheList.stream().filter(e -> fromCode.equals(e.getActivityFormCode())).map(GeneralExpensesDto::getApplyAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        dto.setDiscountCouponApplicationFee(discountCouponApplicationFee);
    }

    public void calDoubleCountApplicationFee(CalculateDto dto) {
        if (Objects.nonNull(dto.getDoubleCountApplicationFee())) {
            return;
        }
        List expensesServiceCacheList = dto.getExpensesServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)expensesServiceCacheList)) {
            dto.setDoubleCountApplicationFee(BigDecimal.ZERO);
            return;
        }
        BigDecimal b1 = BigDecimal.ZERO;
        String fromCode1 = dto.getFormMap().getOrDefault(PromotionPlanActFormEnum.DOUBLE_COUNT_DAILY.getCode(), null);
        if (StringUtils.isNotBlank((CharSequence)fromCode1)) {
            b1 = expensesServiceCacheList.stream().filter(e -> fromCode1.equals(e.getActivityFormCode())).map(GeneralExpensesDto::getApplyAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        BigDecimal b2 = BigDecimal.ZERO;
        String fromCode2 = dto.getFormMap().getOrDefault(PromotionPlanActFormEnum.DOUBLE_COUNT_CONTRACT.getCode(), null);
        if (StringUtils.isNotBlank((CharSequence)fromCode2)) {
            b2 = expensesServiceCacheList.stream().filter(e -> fromCode2.equals(e.getActivityFormCode())).map(GeneralExpensesDto::getApplyAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        dto.setDoubleCountApplicationFee(b1.add(b2));
    }

    public void calPutInFee(CalculateDto dto) {
        if (Objects.nonNull(dto.getPutInFee())) {
            return;
        }
        List expensesServiceCacheList = dto.getExpensesServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)expensesServiceCacheList)) {
            dto.setPutInFee(BigDecimal.ZERO);
            return;
        }
        String feeOut = dto.getFormMap().getOrDefault(PromotionPlanActFormEnum.FEE_POOL_PUT.getCode(), "");
        Map itemMap = this.dictToolkitService.findMapByDictTypeCode("budget_act_form");
        String itemCode = itemMap.getOrDefault(PromotionPlanPutCostEnum.PUT_IN_FEE.getCode(), null);
        if (StringUtils.isBlank((CharSequence)itemCode)) {
            dto.setPutInFee(BigDecimal.ZERO);
            return;
        }
        BigDecimal putInFee = expensesServiceCacheList.stream().filter(e -> !feeOut.equals(e.getActivityFormCode())).filter(e -> itemCode.equals(e.getBudgetItemCode1())).map(GeneralExpensesDto::getApplyAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        dto.setPutInFee(putInFee);
    }

    public void calMonthInventoryTotal(CalculateDto dto) {
        if (Objects.nonNull(dto.getMonthInventoryTotal())) {
            return;
        }
        List purchaseSaleDtoList = dto.getPurchaseSaleServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)purchaseSaleDtoList)) {
            dto.setMonthInventoryTotal(BigDecimal.ZERO);
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (PurchaseSaleDto saleDto : purchaseSaleDtoList) {
            if (StringUtils.isNotBlank((CharSequence)dto.getPurchaseId()) && saleDto.getId().equals(dto.getPurchaseId())) {
                if (null == dto.getMonthInventoryEnd() || null == dto.getPromotionPrice()) continue;
                total = total.add(dto.getMonthInventoryEnd().multiply(dto.getPromotionPrice()));
                continue;
            }
            if (null == saleDto.getMonthInventoryEnd() || null == saleDto.getPromotionPrice()) continue;
            total = total.add(saleDto.getMonthInventoryEnd().multiply(saleDto.getPromotionPrice()));
        }
        dto.setMonthInventoryTotal(total);
    }

    public void calNextMonthInventoryTotal(CalculateDto dto) {
        if (Objects.nonNull(dto.getNextMonthInventoryTotal())) {
            return;
        }
        List purchaseSaleDtoList = dto.getPurchaseSaleServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)purchaseSaleDtoList)) {
            dto.setNextMonthInventoryTotal(BigDecimal.ZERO);
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (PurchaseSaleDto saleDto : purchaseSaleDtoList) {
            if (StringUtils.isNotBlank((CharSequence)dto.getPurchaseId()) && saleDto.getId().equals(dto.getPurchaseId())) {
                if (null == dto.getNextMonthEndInventory() || null == dto.getNextMonthInventoryAmount()) continue;
                total = total.add(dto.getNextMonthEndInventory().multiply(dto.getNextMonthInventoryAmount()));
                continue;
            }
            if (null == saleDto.getNextMonthEndInventory() || null == saleDto.getNextMonthInventoryAmount()) continue;
            total = total.add(saleDto.getNextMonthEndInventory().multiply(saleDto.getNextMonthInventoryAmount()));
        }
        dto.setNextMonthInventoryTotal(total);
    }

    public void calMonthSaleGmvTotal(CalculateDto dto) {
        if (Objects.nonNull(dto.getMonthSaleGmvTotal())) {
            return;
        }
        List monthSaleServiceCacheList = dto.getMonthSaleServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)monthSaleServiceCacheList)) {
            dto.setMonthSaleGmvTotal(BigDecimal.ZERO);
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (CurrentMonthSaleDto saleDto : monthSaleServiceCacheList) {
            if (null == saleDto.getGmv()) continue;
            total = total.add(saleDto.getGmv());
        }
        dto.setMonthSaleGmvTotal(total);
    }

    public void calMonthInventoryStandTotal(CalculateDto dto) {
        if (Objects.nonNull(dto.getMonthInventoryStandTotal())) {
            return;
        }
        List purchaseSaleDtoList = dto.getPurchaseSaleServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)purchaseSaleDtoList)) {
            dto.setMonthInventoryStandTotal(BigDecimal.ZERO);
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (PurchaseSaleDto saleDto : purchaseSaleDtoList) {
            if (StringUtils.isNotBlank((CharSequence)dto.getPurchaseId()) && saleDto.getId().equals(dto.getPurchaseId())) {
                if (null == dto.getMonthInventoryEnd() || null == dto.getStandardRetailPrice()) continue;
                total = total.add(dto.getMonthInventoryEnd().multiply(dto.getStandardRetailPrice()));
                continue;
            }
            if (null == saleDto.getMonthInventoryEnd() || null == saleDto.getStandardRetailPrice()) continue;
            total = total.add(saleDto.getMonthInventoryEnd().multiply(saleDto.getStandardRetailPrice()));
        }
        dto.setMonthInventoryStandTotal(total);
    }

    public void calNextMonthInventoryStandTotal(CalculateDto dto) {
        if (Objects.nonNull(dto.getNextMonthInventoryStandTotal())) {
            return;
        }
        List purchaseSaleDtoList = dto.getPurchaseSaleServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)purchaseSaleDtoList)) {
            dto.setMonthInventoryStandTotal(BigDecimal.ZERO);
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (PurchaseSaleDto saleDto : purchaseSaleDtoList) {
            if (StringUtils.isNotBlank((CharSequence)dto.getPurchaseId()) && saleDto.getId().equals(dto.getPurchaseId())) {
                if (null == dto.getNextMonthEndInventory() || null == dto.getStandardRetailPrice()) continue;
                total = total.add(dto.getNextMonthEndInventory().multiply(dto.getStandardRetailPrice()));
                continue;
            }
            if (null == saleDto.getNextMonthEndInventory() || null == saleDto.getStandardRetailPrice()) continue;
            total = total.add(saleDto.getNextMonthEndInventory().multiply(saleDto.getStandardRetailPrice()));
        }
        dto.setNextMonthInventoryStandTotal(total);
    }

    public void discountBeforeRatio(CalculateDto dto) {
        List monthSaleServiceCacheList = dto.getMonthSaleServiceCacheList();
        if (CollectionUtils.isEmpty((Collection)monthSaleServiceCacheList)) {
            dto.setDiscountBeforeRatio(BigDecimal.ZERO);
            return;
        }
        BigDecimal discountBeforeTotalCustomer = monthSaleServiceCacheList.stream().map(e -> this.bdNull(e.getEstimatedAmountBefore())).reduce(BigDecimal.ZERO, BigDecimal::add);
        dto.setDiscountBeforeRatio(dto.getEstimatedAmountBefore().divide(discountBeforeTotalCustomer, 6, 4));
    }

    private BigDecimal bdNull(BigDecimal b) {
        return b == null ? BigDecimal.ZERO : b;
    }
}

