package com.biz.crm.tpm.business.activity.apply.rules.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/11/8 16:21
 * @description: 活动申请规则-促销规划金额计算Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityApplyRulesPromotionPlanAmountDto", description = "活动申请规则-促销规划金额计算Dto")
public class ActivityApplyRulesPromotionPlanAmountDto extends TenantFlagOpDto {

    @ApiModelProperty(value = "租户编号",hidden = true)
    private String tenantCode;

    @ApiModelProperty("销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty("平台")
    private String platformCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("电商渠道")
    private String estoreChannel;

}
