package com.biz.crm.tpm.business.activity.apply.rules.sdk.dto;

import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.PurchaseSaleDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2022/12/21 9:54
 * @description: 计算dto
 */
@Data
@ApiModel(value = "计算dto")
public class CalculateDto {

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("系数")
    private BigDecimal ratio;

    //    @ApiModelProperty("建议零售价（元）")
//    private BigDecimal suggestedRetailPrice;
    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice;

    @ApiModelProperty("平台供货价（元）")
    private BigDecimal platformSupplyPrice;

    @ApiModelProperty("活动底价（元）")
    private BigDecimal activityBasePrice;

    @ApiModelProperty("组合数量")
    private BigDecimal combinationQuantity;

    @ApiModelProperty("预计销量（箱）")
    private BigDecimal estimatedSalesBox;

    @ApiModelProperty("预计销量（吨）")
    private BigDecimal estimatedSalesTon;

    @ApiModelProperty("增值税（元）")
    private BigDecimal vat;


    /**
     * 当月销售-特有字段
     */
    @ApiModelProperty("预计折前销售额（元）")
    private BigDecimal estimatedAmountBefore;

    @ApiModelProperty("预计折后销售额（元）")
    private BigDecimal estimatedAmountAfter;

    /**
     * 当月送货-特有字段
     */
    @ApiModelProperty("预计销售额（元）")
    private BigDecimal estimatedAmount;

    /**
     * GMV（元）
     */
    @ApiModelProperty("GMV（元）")
    private BigDecimal gmv;

    /**
     * 采销库存费用-特有字段
     */
    @ApiModelProperty("供货价（元）")
    private BigDecimal supplyPrice;

    /**
     * 2023-01-17 改为 本月库存预估售价（元）
     */
    @ApiModelProperty("促销售价（元）")
    private BigDecimal promotionPrice;

    @ApiModelProperty("本月期末库存（箱）")
    private BigDecimal monthInventoryEnd;

    @ApiModelProperty("次月期末库存（箱）")
    private BigDecimal nextMonthEndInventory;

    @ApiModelProperty("次月库存预估售价（元）")
    private BigDecimal nextMonthInventoryAmount;

    @ApiModelProperty("当月猫卡")
    private BigDecimal monthCatCard;

    @ApiModelProperty("次月猫卡")
    private BigDecimal nextMonthCatCard;

    @ApiModelProperty("当月优惠卷")
    private BigDecimal monthCoupon;

    @ApiModelProperty("次月优惠卷")
    private BigDecimal nextMonthCoupon;

    @ApiModelProperty("成本价（元）")
    private BigDecimal costPrice;

    @ApiModelProperty("（当月库存数量*当月库存预估售价）汇总")
    private BigDecimal monthInventoryTotal;

    @ApiModelProperty("（次月库存数量*次月库存预估售价）汇总")
    private BigDecimal nextMonthInventoryTotal;

    @ApiModelProperty("【（当月库存数量*标准零售价）汇总】")
    private BigDecimal monthInventoryStandTotal;

    @ApiModelProperty("【（次月库存数量*标准零售价）汇总】")
    private BigDecimal nextMonthInventoryStandTotal;

    @ApiModelProperty("当月销售中的GMV汇总")
    private BigDecimal monthSaleGmvTotal;

    @ApiModelProperty("费用申请中活动形式为猫超卡的申请金额之和")
    private BigDecimal catCardApplicationFee;

    @ApiModelProperty("费用申请中活动形式为优惠券的申请金额之和")
    private BigDecimal discountCouponApplicationFee;

    @ApiModelProperty("当月销售中【活动底价*组合数量*预计销量】之和")
    private BigDecimal currentMonthSaleBasePriceCombinationQuantityEstimatedSalesBoxSum;

    @ApiModelProperty("费用申请中活动形式为“双计-日常”和“双计-合同款”的明细行的申请金额合计")
    private BigDecimal doubleCountApplicationFee;

    @ApiModelProperty("费用申请中活动形式对应的以及预算项目为【投放费用】的明细行的申请金额合计")
    private BigDecimal putInFee;

    @ApiModelProperty("当前行的预计折前销售额（当月销售）/预计折前销售额汇总（当月销售）")
    private BigDecimal discountBeforeRatio;

    @ApiModelProperty("当月销售缓存列表")
    List<CurrentMonthSaleDto> monthSaleServiceCacheList;

    @ApiModelProperty("费用申请缓存列表")
    List<GeneralExpensesDto> expensesServiceCacheList;

    @ApiModelProperty("采销库存缓存列表")
    List<PurchaseSaleDto> purchaseSaleServiceCacheList;

    /**
     * 双计费用率
     */
    @ApiModelProperty("双计费用率")
    private BigDecimal doubleCountCost;


//    /**
//     * 投放费用率
//     */
//    @ApiModelProperty("投放费用率dto")
//    private PutCostDto putCostDto;

    /**
     * 公式
     */
    @ApiModelProperty("公式")
    private String formula;

    /**
     * 活动形式map
     */
    @ApiModelProperty("活动形式map")
    private Map<String, String> formMap;


    @ApiModelProperty("当月销售当前行id")
    String monthSaleId;

    @ApiModelProperty("费用申请当前行id")
    String expensesId;

    @ApiModelProperty("采销库存当前行id")
    String purchaseId;


}
