package com.biz.crm.tpm.business.activity.apply.rules.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/11/8 16:21
 * @description: 活动申请规则-促销规划金额计算-当月送货Dto
 */
@Data
@ApiModel(value = "MonthDeliveryPromotionPlanAmountDto", description = "活动申请规则-促销规划金额计算-当月送货Dto")
public class MonthDeliveryPromotionPlanAmountDto {

    @ApiModelProperty("销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty("平台")
    private String platformCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("电商渠道")
    private String channelCode;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("系数")
    private BigDecimal ratio;

//    @ApiModelProperty("建议零售价（元）")
//    private BigDecimal suggestedRetailPrice;
    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice;

    @ApiModelProperty("平台供货价（元）")
    private BigDecimal platformSupplyPrice;

    @ApiModelProperty("活动底价（元）")
    private BigDecimal activityBasePrice;

    @ApiModelProperty("组合数量")
    private BigDecimal combinationQuantity;

    @ApiModelProperty("预计销量（箱）")
    private BigDecimal estimatedSalesBox;

    @ApiModelProperty("预计销量（吨）")
    private BigDecimal estimatedSalesTon;

    @ApiModelProperty("增值税（元）")
    private BigDecimal vat;

    @ApiModelProperty("成本价（元）")
    private BigDecimal costPrice;


    /**
     * 当月送货-特有字段
     */
    @ApiModelProperty("预计销售额（元）")
    private BigDecimal estimatedAmount;


    @ApiModelProperty("缓存key")
    private String cacheKey;

    @ApiModelProperty("其他费用缓存key")
    private String cacheKeyOther;


    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;


}
