package com.biz.crm.tpm.business.activity.apply.rules.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/11/8 16:21
 * @description: 活动申请规则-促销规划金额计算-"采销库存费用Dto
 */
@Data
@ApiModel(value = "PurchaseSalePromotionPlanAmountDto", description = "活动申请规则-促销规划金额计算-采销库存费用Dto")
public class PurchaseSalePromotionPlanAmountDto {

    @ApiModelProperty("销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty("平台")
    private String platformCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("电商渠道")
    private String channelCode;


    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice;

    /**
     * 采销库存费用-特有字段
     */
    @ApiModelProperty("供货价（元）")
    private BigDecimal supplyPrice;

    @ApiModelProperty("促销售价（元）")
    private BigDecimal promotionPrice;

    @ApiModelProperty("本月期末库存（箱）")
    private BigDecimal monthInventoryEnd;

    /**
     * 次月期末库存（箱）
     */
    @ApiModelProperty("次月期末库存（箱）")
    private BigDecimal nextMonthEndInventory;

    /**
     * 次月库存预估售价（元）
     */
    @ApiModelProperty("次月库存预估售价（元）")
    private BigDecimal nextMonthInventoryAmount;

    /**
     * 投放费用率
     */
    @ApiModelProperty("投放费用率dto")
    private PutCostDto putCostDto;

    @ApiModelProperty("成本价（元）")
    private BigDecimal costPrice;


    @ApiModelProperty("缓存key")
    private String cacheKey;

    @ApiModelProperty("促销规划编码")
    private String promotionPlanCode;

    @ApiModelProperty("当月销售缓存key")
    private String monthSaleCacheKey;

    @ApiModelProperty("费用申请缓存key")
    private String generalExpensesCacheKey;


}
