package com.biz.crm.tpm.business.activity.apply.rules.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2022/11/8 20:00
 * @description: 促销规划活动形式 枚举 注：若促销规划中新加了活动形式则需要将字段名放入此枚举中
 */
public enum PromotionPlanActFormEnum {
    /**
     * 大日期处理（元）
     */
    LARGE_DATE_PROCESS("largeDateProcess", "大日期处理（元）"),
    /**
     * 产品促销（元）
     */
    PRODUCT_PROMOTION("productPromotion", "产品促销（元）"),
    /**
     * 新客专享（元）
     */
    NEW_CUSTOMER("newCustomer", "新客专享（元）"),
    /**
     * 老客留存（元）
     */
    OLD_CUSTOMER("oldCustomer", "老客留存（元）"),
    /**
     * 达人佣金（抖音）（元）
     */
    TIKTOK_MASTER("tiktokMaster", "达人佣金（抖音）（元）"),
    /**
     * 平台毛保（元）
     */
    PLATFORM_GROSS_PROTECTION("platformGrossProtection", "平台毛保（元）"),
    /**
     * 平台服务费（元）
     */
    PLATFORM_SERVICE("platformService", "平台服务费（元）"),
    /**
     * 平台返点费用（元）
     */
    PLATFORM_REBATE("platformRebate", "平台返点费用（元）"),
    /**
     * 平台佣金扣点（元）
     */
    PLATFORM_COMMISSION("platformCommission", "平台佣金扣点（元）"),
    /**
     * 销售返点（元）
     */
    SALE_COMMISSION("saleCommission", "销售返点（元）"),
    /**
     * 物流费用（元）
     */
    LOGISTICS("logistics", "物流费用（元）"),
    /**
     * 渠道推广费（元）
     */
    CHANNEL_PROMOTION_FEE("channelPromotionFee", "渠道推广费（元）"),
    /**
     * 采购返点（元）
     */
    PURCHASE_REBATE("purchaseRebate", "采购返点（元）"),
    /**
     * 费用池-补差
     */
    FEE_POOL_DIFFERENCE("feePoolDifference", "费用池-补差"),
    /**
     * 费用池-销售返
     */
    FEE_POOL_SALE_COMMISSION("feePoolSaleCommission", "费用池-销售返"),
    /**
     * 费用池-采购返
     */
    FEE_POOL_PURCHASE_REBATE("feePoolPurchaseRebate", "费用池-采购返"),
    /**
     * 费用池-投放
     */
    FEE_POOL_PUT("feePoolPut", "费用池-投放"),
    /**
     * 费用池-毛保
     */
    FEE_POOL_GROSS_PROTECTION("feePoolGrossProtection", "费用池-毛保"),
    /**
     * 猫超卡
     */
    CAT_CARD("catCard", "猫超卡"),
    /**
     * 优惠券
     */
    DISCOUNT_COUPON("discountCoupon", "优惠券"),
    /**
     * 双计-日常
     */
    DOUBLE_COUNT_DAILY("doubleCountDaily", "双计-日常"),
    /**
     * 双计-合同款
     */
    DOUBLE_COUNT_CONTRACT("doubleCountContract", "双计-合同款"),
    /**
     * 仓间不均（元）
     */
    UNEVEN("uneven", "仓间不均（元）"),
    /**
     * 高周转（元）
     */
    HIGH_TURNOVER("highTurnover", "高周转（元）"),
    /**
     * 组合装费用
     */
    PRE_PACK("prePack", "组合装费用"),
    /**
     * 到手价政策费用
     */
    TAKE_HOME_PRICE_POLICY_FEE("takeHomePricePolicyFee", "到手价政策费用"),
    /**
     * 分销基础返点（旬返）
     */
    DISTRIBUTION_BASE_TEN("distributionBaseTen", "分销基础返点（旬返）"),
    /**
     * 分销基础返点（月返）
     */
    DISTRIBUTION_BASE_MONTH("distributionBaseMonth", "分销基础返点（月返）"),
    /**
     * 月度目标达成返点（分销）
     */
    MONTH_GOAL_ACHIEVEMENT("monthGoalAchievement", "月度目标达成返点（分销）"),
    /**
     * 投放费用（分销）
     */
    PUT_FEE("putFee", "投放费用（分销）"),
    /**
     * 物流支持（分销）
     */
    LOGISTICS_SUPPORT("logisticsSupport", "物流支持（分销）"),
    /**
     * 年度目标达成返点（分销）
     */
    YEAR_GOAL_ACHIEVEMENT("yearGoalAchievement", "年度目标达成返点（分销）"),
    /**
     * 人员费用（分销）
     */
    STAFF_FEE("staffFee", "人员费用（分销）"),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    PromotionPlanActFormEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static PromotionPlanActFormEnum codeToEnum(String code) {
        PromotionPlanActFormEnum actFormEnum = null;
        PromotionPlanActFormEnum[] var2 = values();

        for (PromotionPlanActFormEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                actFormEnum = typeEnum;
            }
        }

        return actFormEnum;
    }
}
