package com.biz.crm.tpm.business.activity.apply.rules.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2022/11/8 20:00
 * @description: 促销规划一级预算项目 枚举 注：若促销规划中一级预算项目的字段更改，则需要修改此枚举
 */
public enum PromotionPlanPutCostEnum {
    /**
     * 一级预算项目
     */
    BUDGET_ITEM_CODE_1("budgetItemCode1", "一级预算项目"),
    /**
     * 投放费用
     */
    PUT_IN_FEE("putInFee", "投放费用"),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    PromotionPlanPutCostEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static PromotionPlanPutCostEnum codeToEnum(String code) {
        PromotionPlanPutCostEnum putCostEnum = null;
        PromotionPlanPutCostEnum[] var2 = values();

        for (PromotionPlanPutCostEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                putCostEnum = typeEnum;
            }
        }

        return putCostEnum;
    }
}
