package com.biz.crm.tpm.business.activity.apply.rules.sdk.event.log;

import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.log.ActivityApplyRulesLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author: chenlong
 * @date: 2022/11/12 9:57
 * @description: 活动申请规则管理日志监听
 */
public interface ActivityApplyRulesEventListener extends NebulaEvent {

    /**
     * 创建事件
     *
     * @param eventDto 事件dto
     */
    void onCreate(ActivityApplyRulesLogEventDto eventDto);

    /**
     * 删除事件
     *
     * @param eventDto 事件dto
     */
    void onDelete(ActivityApplyRulesLogEventDto eventDto);

    /**
     * 更新日志
     *
     * @param eventDto 事件dto
     */
    void onUpdate(ActivityApplyRulesLogEventDto eventDto);

    /**
     * 启用
     *
     * @param eventDto 事件dto
     */
    void onEnable(ActivityApplyRulesLogEventDto eventDto);

    /**
     * 禁用
     *
     * @param eventDto 事件dto
     */
    void onDisable(ActivityApplyRulesLogEventDto eventDto);
}
