package com.biz.crm.tpm.business.activity.apply.rules.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.dto.*;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesFormulaVariableVo;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesPromotionPlanAmountVo;
import com.biz.crm.tpm.business.activity.apply.rules.sdk.vo.ActivityApplyRulesVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author chenlong
 * @date 2022/11/8 11:35
 * @description 活动申请规则表(ActivityApplyRules)表服务接口
 */
public interface ActivityApplyRulesService {

    /**
     * 分页查询数据
     *
     * @param pageable              分页对象
     * @param activityApplyRulesDto 查询dto
     * @return Page<ActivityApplyRulesVo>
     */
    Page<ActivityApplyRulesVo> findByConditions(Pageable pageable, ActivityApplyRulesDto activityApplyRulesDto);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    ActivityApplyRulesVo findById(String id);

    /**
     * 新增数据
     *
     * @param activityApplyRulesDto 实体对象
     */
    void create(ActivityApplyRulesDto activityApplyRulesDto);

    /**
     * 修改新据
     *
     * @param activityApplyRulesDto 实体对象
     */
    void update(ActivityApplyRulesDto activityApplyRulesDto);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     */
    void delete(List<String> idList);

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 获取申请规则公式变量
     *
     * @return 列表数据
     */
    List<ActivityApplyRulesFormulaVariableVo> getFormulaVariable();


    /**
     * 当月销售计算规则金额
     *
     * @param dto 规则匹配参数
     * @return ActivityApplyRulesPromotionPlanAmountVo
     */
    ActivityApplyRulesPromotionPlanAmountVo calAmountMonthSale(MonthSalePromotionPlanAmountDto dto);

    /**
     * 当月送货计算规则金额
     *
     * @param dto 规则匹配参数
     * @return ActivityApplyRulesPromotionPlanAmountVo
     */
    ActivityApplyRulesPromotionPlanAmountVo calAmountMonthDelivery(MonthDeliveryPromotionPlanAmountDto dto);

    /**
     * 采销库存费用计算规则金额
     *
     * @param dto 规则匹配参数
     * @return ActivityApplyRulesPromotionPlanAmountVo
     */
    ActivityApplyRulesPromotionPlanAmountVo calAmountPurchaseSale(PurchaseSalePromotionPlanAmountDto dto);

    /**
     * 采销库存费用重新计算
     *
     * @param dto 规则匹配参数
     */
    void reCalPurchaseSale(PurchaseSaleReCalDto dto);
}
