package com.biz.crm.tpm.business.activity.apply.rules.sdk.utils;

import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/26 14:44
 * @description:
 */
@Component
public class ActivityApplyRulesVariableUtil {

    /**
     * 将表达式里变量替换为可计算的数字
     *
     * @param expression       expression
     * @param variables        variables
     * @param variableValueMap variableValueMap
     */
    public String replaceExpression(String expression, Set<String> variables, Map<String, BigDecimal> variableValueMap) {
        for (String variable : variables) {
            BigDecimal value = variableValueMap.get(variable);
            Validate.notNull(value, "计算时检测到变量【%s】值为空", variable);
            //替换实际的值
            expression = expression.replace(variable, value.toPlainString());
        }
        return expression;
    }
}
